﻿using Avalonia;
using Avalonia.Controls;
using Avalonia.Input;
using Avalonia.Markup.Xaml;
using Avalonia.Media;
using Avalonia.Media.Imaging;
using GameMakerAvalonia.Models;
using RawResources.Models;
using System;
using System.IO;

namespace GameMakerAvalonia.EditPanels
{
    public class TileSetEditPanel : UserControl
    {
        private int textureKey;
        private Session session;
        private IBitmap cacheTextureImage;
        private string textureFilename;


        public TileSetEditPanel()
        {
            this.InitializeComponent();
        }


        private void InitializeComponent()
        {
            AvaloniaXamlLoader.Load(this);

            this.cacheTextureImage = null;

            this.PointerPressed += TileSetEditPanel_PointerPressed;
        }

        
        public void SetParameters(Session session, int textureKey)
        {
            this.textureKey = textureKey;
            this.session = session;

            RawResource texture = this.session.RawContentManager.TextureRepository.GetContent(textureKey);
            this.textureFilename = this.session.WorkingDirectory + Path.DirectorySeparatorChar + "Content" + Path.DirectorySeparatorChar + texture.SystemFilePath + ".png";

            this.cacheTextureImage = new Bitmap(this.textureFilename);
            
            this.Width = cacheTextureImage.Size.Width;
            this.Height = cacheTextureImage.Size.Height;
        }


        public override void Render(DrawingContext graphics)
        {
            base.Render(graphics);

            if (this.session == null) return;

            RawResource texture = this.session.RawContentManager.TextureRepository.GetContent(textureKey);
            if (texture == null) return;

            IBrush nonPassableBrush = new SolidColorBrush(Color.FromRgb(Convert.ToByte(255), Convert.ToByte(0), Convert.ToByte(0)));
            IPen nonPassablePen = new Pen(nonPassableBrush);

            //draw image
            graphics.DrawImage(this.cacheTextureImage, new Rect(this.cacheTextureImage.Size), new Rect(this.cacheTextureImage.Size));

            //draw grid based on tile set            
            foreach (TileSetDefinition tileSet in this.session.RawContentManager.TileSetRepository.GetListOfContent())
            {
                if (tileSet.TextureKey == this.textureKey)
                {
                    Rect borderRect = new Rect(tileSet.X, tileSet.Y, tileSet.Width - 1, tileSet.Height - 1);

                    if (tileSet.Passable == false)
                    {
                        graphics.DrawRectangle(nonPassablePen, borderRect);
                    }
                }
            }
        }


        private void TileSetEditPanel_PointerPressed(object sender, PointerPressedEventArgs e)
        {
            PointerPoint point = e.GetCurrentPoint(this);
            int tx = (int)point.Position.X;
            int ty = (int)point.Position.Y;

            foreach (TileSetDefinition tileSet in this.session.RawContentManager.TileSetRepository.GetListOfContent())
            {
                if (tileSet.TextureKey == this.textureKey)
                {
                    if ((tx >= tileSet.X) && (tx <= (tileSet.X + tileSet.Width)))
                    {
                        if ((ty >= tileSet.Y) && (ty <= (tileSet.Y + tileSet.Height)))
                        {
                            tileSet.Passable = !tileSet.Passable;
                        }
                    }
                }
            }

            this.InvalidateVisual();
        }



    }
}
