﻿using System.IO;
using RawResources.Manager;


namespace GameMakerAvalonia.Models
{
    public class Session
    {
        public string WorkingDirectory { get; set; }
        public IRawContentManager RawContentManager { get; set; }


        public bool Save()
        {
            this.RawContentManager.FontRepository.Save(this.WorkingDirectory + Path.DirectorySeparatorChar + "fonts.csv");
            this.RawContentManager.SongRepository.Save(this.WorkingDirectory + Path.DirectorySeparatorChar + "songs.csv");
            this.RawContentManager.SoundEffectRepository.Save(this.WorkingDirectory + Path.DirectorySeparatorChar + "soundeffects.csv");
            this.RawContentManager.TextureRepository.Save(this.WorkingDirectory + Path.DirectorySeparatorChar + "textures.csv");
            this.RawContentManager.TileSetRepository.Save(this.WorkingDirectory + Path.DirectorySeparatorChar + "tilesets.csv");
            this.RawContentManager.WorldMapRepository.Save(this.WorkingDirectory + Path.DirectorySeparatorChar + "worldmaps.csv");
            this.RawContentManager.PlayerRepository.Save(this.WorkingDirectory + Path.DirectorySeparatorChar + "player.csv");
            this.RawContentManager.DestructableBlockRepository.Save(this.WorkingDirectory + Path.DirectorySeparatorChar + "destructableblocks.csv");
            this.RawContentManager.EnemyRepository.Save(this.WorkingDirectory + Path.DirectorySeparatorChar + "enemies.csv");

            return true;
        }

    }
}
