﻿using Avalonia.Controls;
using Avalonia.Markup.Xaml;
using GameMakerAvalonia.EditPanels;
using GameMakerAvalonia.Models;
using RawResources.Models;
using System;
using System.Collections.Generic;


namespace GameMakerAvalonia.Panels
{
    public class TileSetsPanel : UserControl
    {
        private Session session;
        private IList<RawResource> resources;


        public TileSetsPanel()
        {
            this.InitializeComponent();
        }


        private void InitializeComponent()
        {
            AvaloniaXamlLoader.Load(this);

            this.FindControl<DataGrid>("ListGridView").CurrentCellChanged += ListGridView_CurrentCellChanged;
        }


        public void SetSession(Session session)
        {
            this.session = session;

            LoadSession();
        }


        private void LoadSession()
        {
            var grid = this.FindControl<DataGrid>("ListGridView");

            this.resources = new List<RawResource>();

            foreach (RawResource texture in this.session.RawContentManager.TextureRepository.GetListOfContent())
            {
                bool isUsed = false;

                foreach (TileSetDefinition tileSet in this.session.RawContentManager.TileSetRepository.GetListOfContent())
                {
                    if (tileSet.TextureKey == texture.Key) isUsed = true;
                }

                if (isUsed) this.resources.Add(texture);
            }

            grid.Items = this.resources;
        }


        private void ListGridView_CurrentCellChanged(object sender, EventArgs e)
        {
            var grid = this.FindControl<DataGrid>("ListGridView");

            if (grid.SelectedItem != null)
            {
                var image = this.FindControl<Image>("TextureImage");
                RawResource item = (RawResource)grid.SelectedItem;

                TileSetEditPanel tileSetEditPanel = this.FindControl<TileSetEditPanel>("TileSetEditPanel");
                tileSetEditPanel.SetParameters(this.session, item.Key);
                tileSetEditPanel.InvalidateVisual();
            }
        }


    }
}
