﻿using GameResources.Manager;
using GameResources.Models.Game;


namespace GameResources.Factories
{
    public class GameStateFactory
    {
        private readonly IGameContentManager gameContentManager;

        public GameStateFactory(IGameContentManager gameContentManager)
        {
            this.gameContentManager = gameContentManager;
        }


        public GameState CreateNew()
        {
            GameState gameState = new GameState(this.gameContentManager)
            {
                Player = gameContentManager.PlayerRepository.GetContentByKey(0)
            };

            gameState.ActivateWorldMapCell();

            return gameState;
        }

    }
}
