﻿using GameResources.Factories;
using GameResources.Manager;
using GameResources.Models.Game;
using System;
using System.IO;
using System.IO.IsolatedStorage;
using System.Text.Json;


namespace GameResources.Logic.Game
{
    public class GameLoader
    {
        private IGameContentManager gameContentManager;


        public GameLoader(IGameContentManager gameContentManager)
        {
            this.gameContentManager = gameContentManager;
        }


        public GameState Preview(int slot)
        {
            IsolatedStorageFile savegameStorage = IsolatedStorageFile.GetUserStoreForAssembly();
            IsolatedStorageFileStream isolatedFileStream = null;
            string filename = "metroid-" + slot + ".sav";
            SaveContainer container = null;

            try
            {
                isolatedFileStream = savegameStorage.OpenFile(filename, System.IO.FileMode.Open);
            }
            catch (Exception)
            {
                return null;
            }

            if (isolatedFileStream != null)
            {
                StreamReader reader = new StreamReader(isolatedFileStream);
                string json = reader.ReadToEnd();

                try
                {
                    container = (SaveContainer)JsonSerializer.Deserialize(json, typeof(SaveContainer));
                }
                catch(Exception)
                {
                    container = null;
                }

                reader.Close();
                isolatedFileStream.Close();
            }

            if (container == null) return null;

            GameState gameState = new GameState(this.gameContentManager)
            {
                Player = gameContentManager.PlayerRepository.GetContentByKey(0)
            };

            gameState.GameSlot = slot;
            gameState.Player.CharacterStats = container.PlayerStats;
            gameState.Player.Inventory = container.PlayerInventory;
            gameState.Player.Position = container.PlayerPosition;
            gameState.PickedUpItems = container.PickedUpItems;
            gameState.VariableState = container.VariableState;
            gameState.MapHistory = container.MapHistory;

            return gameState;
        }


        public GameState Load(int slot)
        {
            GameState gameState = Preview(slot);

            gameState.ActivateWorldMapCell();

            return gameState;
        }


    }
}
