﻿using GameResources.Models.Game;
using GameResources.Models.Samus;
using GameResources.Models.World;


namespace GameResources.Logic.Physics
{
    public class PlayerPositionAdjuster
    {
        private readonly WorldMapCell worldMapCell;
        private readonly GameState gameState;
        private readonly Player player;


        public PlayerPositionAdjuster(Player player, GameState gameState)
        {
            this.player = player;
            this.gameState = gameState;
            this.worldMapCell = gameState.GetActiveWorldMapCell();
        }


        public void AdjustIfNeeded()
        {
            CollisionDetection collisionDetection = new CollisionDetection(this.player, this.worldMapCell, this.gameState);
            if (collisionDetection.HasCollidedInWorld() == false) return;


            //ball scenario
            int dx = 16;
            if(collisionDetection.HasCollidedInWorldAtPosition(this.player.Position.PositionX - dx, this.player.Position.PositionY) == false)
            {
                this.player.Position.PositionX -= dx;
                return;
            }
            else if (collisionDetection.HasCollidedInWorldAtPosition(this.player.Position.PositionX + dx, this.player.Position.PositionY) == false)
            {
                this.player.Position.PositionX += dx;
                return;
            }

        }


    }
}
