﻿using System.Text;


namespace RawResources.Models
{
    public class DestructableBlockDefinition
    {
        public int Key { get; set; }
        public string Name { get; set; }
        public int TileSetKey { get; set; }
        public int RevealTileSetKey { get; set; }
        public DamageType DamageType { get; set; }
        public string OnlyShowIfVariableIsFalse { get; set; }
        public string SetVariableToTrueUponDestruction { get; set; }


        public override string ToString()
        {
            return this.Name + " (" + DamageType.ToString() + ")";
        }


        public static string GetCsvTitle()
        {
            return "Key,Name,TileSetKey,RevealTileSetKey,DamageType,OnlyShowIfVariableIsFalse,SetVariableToTrueUponDestruction";
        }


        public string ToCsvString()
        {
            StringBuilder line = new StringBuilder();

            line.Append(Key);
            line.Append(',');
            line.Append(Name);
            line.Append(',');
            line.Append(TileSetKey);
            line.Append(',');
            line.Append(RevealTileSetKey);
            line.Append(',');
            line.Append(DamageType);
            line.Append(',');
            line.Append(OnlyShowIfVariableIsFalse);
            line.Append(',');
            line.Append(SetVariableToTrueUponDestruction);

            return line.ToString();
        }

    }
}
