﻿namespace RawResources.Models
{
    public class ItemPlacementDefinition
    {
        public int WorldKey { get; set; }
        public int CellX { get; set; }
        public int CellY { get; set; }
        public int X { get; set; }
        public int Y { get; set; }
        public ItemType ItemType { get; set; }


        public override bool Equals(object o)
        {
            if(o.GetType() == typeof(ItemPlacementDefinition))
            {
                ItemPlacementDefinition other = (ItemPlacementDefinition)o;

                return (this.WorldKey == other.WorldKey &&
                    this.CellX == other.CellX &&
                    this.CellY == other.CellY &&
                    this.X == other.X &&
                    this.Y == other.Y &&
                    this.ItemType == other.ItemType);
            }
            else
            {
                return false;
            }
        }

        public override string ToString()
        {
            return WorldKey + "|" + CellX + "|" + CellY + "|" + X + "|" + Y + "|" + ItemType;
        }

        public override int GetHashCode()
        {
            return base.GetHashCode();
        }

    }
}
