﻿using System.Collections.Generic;
using System.Text;


namespace RawResources.Models
{
    public class TileSetDefinition
    {
        public int Key { get; set; }
        public int TextureKey { get; set; }
        public int X { get; set; }
        public int Y { get; set; }
        public int Width { get; set; }
        public int Height { get; set; }
        public bool Passable { get; set; }
        public IList<int> AnimationSequence { get; set; }


        public static string GetCsvTitle()
        {
            return "Key,TextureKey,X,Y,Width,Height,Passable,AnimationSequence";
        }


        public string ToCsvString()
        {
            StringBuilder line = new StringBuilder();

            line.Append(Key);
            line.Append(',');
            line.Append(TextureKey);
            line.Append(',');
            line.Append(X);
            line.Append(',');
            line.Append(Y);
            line.Append(',');
            line.Append(Width);
            line.Append(',');
            line.Append(Height);
            line.Append(',');
            line.Append(Passable.ToString());
            line.Append(',');
            line.Append(ConvertAnimationSequenceToText());

            return line.ToString();
        }


        public void SetAnimationSequence(int t1, int t2, int t3, int t4, int t5)
        {
            AnimationSequence.Clear();

            AnimationSequence.Add(t1);
            AnimationSequence.Add(t2);
            AnimationSequence.Add(t3);
            AnimationSequence.Add(t4);
            AnimationSequence.Add(t5);
        }


        private string ConvertAnimationSequenceToText()
        {
            StringBuilder result = new StringBuilder("");

            while (AnimationSequence.Contains(-1)) AnimationSequence.Remove(-1);

            if ((AnimationSequence.Count == 0) || (AnimationSequence.Count == 1)) return "";

            for (int i = 0; i < AnimationSequence.Count; i++)
            {
                result.Append(AnimationSequence[i].ToString());

                if (i != (AnimationSequence.Count - 1)) result.Append("|");
            }

            return result.ToString();
        }

    }
}
