﻿using System.Collections.Generic;
using System.Text;


namespace RawResources.Models
{
    public class WorldMapDefinition
    {
        public int Key { get; set; }
        public string Name { get; set; }
        public string Filename { get; set; }
        public IDictionary<int, IDictionary<int, WorldMapCellDefinition>> Cells { get; }


        public WorldMapDefinition()
        {
            this.Cells = new Dictionary<int, IDictionary<int, WorldMapCellDefinition>>();
        }


        public override string ToString()
        {
            return Key.ToString() + " - " + Name;
        }


        public static string GetCsvTitle()
        {
            return "Key,Name,Filename";
        }


        public string ToCsvString()
        {
            StringBuilder line = new StringBuilder();

            line.Append(Key);
            line.Append(',');
            line.Append(Name);
            line.Append(',');
            line.Append(Filename);
            
            return line.ToString();
        }


        public void AddCell(WorldMapCellDefinition cell)
        {
            if (this.Cells.ContainsKey(cell.WorldMapX) == false) this.Cells.Add(cell.WorldMapX, new Dictionary<int, WorldMapCellDefinition>());

            this.Cells[cell.WorldMapX].Add(cell.WorldMapY, cell);
        }


        public void RemoveCell(WorldMapCellDefinition cell)
        {
            int x = cell.WorldMapX;
            int y = cell.WorldMapY;

            this.Cells[x].Remove(y);
        }


        public IList<WorldMapCellDefinition> GetListOfCells()
        {
            IList<WorldMapCellDefinition> cellList = new List<WorldMapCellDefinition>();
            ICollection<int> xKeys = this.Cells.Keys;

            foreach(int x in xKeys)
            {
                IDictionary<int, WorldMapCellDefinition> column = this.Cells[x];

                ICollection<int> yKeys = column.Keys;

                foreach(int y in yKeys)
                {
                    WorldMapCellDefinition cell = this.Cells[x][y];

                    cellList.Add(cell);
                }
            }

            return cellList;
        }


        public WorldMapCellDefinition GetCellAtLocation(int x, int y)
        {
            IList<WorldMapCellDefinition> cells = GetListOfCells();

            foreach (WorldMapCellDefinition cell in cells)
            {
                if((x >= cell.WorldMapX) && (x <= (cell.WorldMapX + cell.WorldMapWidth - 1)))
                {
                    if ((y >= cell.WorldMapY) && (y <= (cell.WorldMapY + cell.WorldMapHeight - 1)))
                    {
                        return cell;
                    }
                }
            }

            return null;
        }

    }
}
