﻿using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using System.Collections.Generic;


namespace UserInterface.Control
{
    public class Panel : IControl
    {
        public IList<IControl> Controls { get; }
        public Texture2D Texture { get; set; }
        public bool IsSelected { get; set; }
        public bool IsSelectable { get; }
        public Rectangle Location { get; set; }


        public Panel()
        {
            this.Controls = new List<IControl>();
            this.IsSelectable = false;
        }


        public void Draw(SpriteBatch spriteBatch)
        {
            spriteBatch.Draw(Texture, this.Location, Color.White);
        }


        public void Update(long ticks)
        {

        }


        public void Press()
        {

        }
    }
}
