using GameResources.Models;
using GameResources.Models.World;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Microsoft.Xna.Framework;
using RawResources.Models;
using System;
using UserInterface.Helper;

namespace UserInterfaceTests
{
    [TestClass]
    public class CameraTests
    {
        private Rectangle resolution;

        public CameraTests()
        {
            resolution = new Rectangle(0, 0, 1024, 576);
        }


        [TestMethod]
        public void SingleRoom_BottomLeft()
        {
            //arrange
            TileSet tileSet = new TileSet();
            WorldMapCell cell = new WorldMapCell();
            for(int x = 0; x < WorldMapCellDefinition.NUM_TILES_WIDE; x++)
            {
                for(int y = 0; y < WorldMapCellDefinition.NUM_TILES_HIGH; y++)
                {
                    cell.AddTile(x, y, tileSet, tileSet);
                }
            }

            WorldPosition position = new WorldPosition()
            {
                PositionX = 0,
                PositionY = 576
            };

            //act
            Camera camera = new Camera()
            {
                WorldMapCell = cell,
                Position = position,
                Resolution = resolution
            };
            Rectangle drawBounds = camera.GetDrawBounds();

            //assert
            Assert.AreEqual(0, drawBounds.X);
            Assert.AreEqual(0, drawBounds.Y);
            Assert.AreEqual(resolution.Width, drawBounds.Width);
            Assert.AreEqual(resolution.Height, drawBounds.Height);
        }


        [TestMethod]
        public void DoubleTallRoom_BottomLeft()
        {
            //arrange
            TileSet tileSet = new TileSet();
            WorldMapCell cell = new WorldMapCell();
            for (int x = 0; x < WorldMapCellDefinition.NUM_TILES_WIDE; x++)
            {
                for (int y = 0; y < (WorldMapCellDefinition.NUM_TILES_HIGH*2); y++)
                {
                    cell.AddTile(x, y, tileSet, tileSet);
                }
            }

            WorldPosition position = new WorldPosition()
            {
                PositionX = 0,
                PositionY = 576 *2
            };

            //act
            Camera camera = new Camera()
            {
                WorldMapCell = cell,
                Position = position,
                Resolution = resolution
            };
            Rectangle drawBounds = camera.GetDrawBounds();

            //assert
            Assert.AreEqual(0, drawBounds.X);
            Assert.AreEqual(576, drawBounds.Y);
            Assert.AreEqual(resolution.Width, drawBounds.Width);
            Assert.AreEqual(resolution.Height, drawBounds.Height);
        }


        [TestMethod]
        public void DoubleTallRoom_Middle()
        {
            //arrange
            TileSet tileSet = new TileSet();
            WorldMapCell cell = new WorldMapCell();
            for (int x = 0; x < WorldMapCellDefinition.NUM_TILES_WIDE; x++)
            {
                for (int y = 0; y < (WorldMapCellDefinition.NUM_TILES_HIGH * 2); y++)
                {
                    cell.AddTile(x, y, tileSet, tileSet);
                }
            }

            WorldPosition position = new WorldPosition()
            {
                PositionX = 512,
                PositionY = 576 
            };

            //act
            Camera camera = new Camera()
            {
                WorldMapCell = cell,
                Position = position,
                Resolution = resolution
            };
            Rectangle drawBounds = camera.GetDrawBounds();

            //assert
            Assert.AreEqual(0, drawBounds.X);
            Assert.AreEqual(position.PositionY/2, drawBounds.Y);
            Assert.AreEqual(resolution.Width, drawBounds.Width);
            Assert.AreEqual(resolution.Height, drawBounds.Height);
        }


        [TestMethod]
        public void DoubleTallRoom_BottomRight()
        {
            //arrange
            TileSet tileSet = new TileSet();
            WorldMapCell cell = new WorldMapCell();
            for (int x = 0; x < WorldMapCellDefinition.NUM_TILES_WIDE; x++)
            {
                for (int y = 0; y < (WorldMapCellDefinition.NUM_TILES_HIGH * 2); y++)
                {
                    cell.AddTile(x, y, tileSet, tileSet);
                }
            }

            WorldPosition position = new WorldPosition()
            {
                PositionX = 1024,
                PositionY = 576 * 2
            };

            //act
            Camera camera = new Camera()
            {
                WorldMapCell = cell,
                Position = position,
                Resolution = resolution
            };
            Rectangle drawBounds = camera.GetDrawBounds();

            //assert
            Assert.AreEqual(0, drawBounds.X);
            Assert.AreEqual(position.PositionY / 2, drawBounds.Y);
            Assert.AreEqual(resolution.Width, drawBounds.Width);
            Assert.AreEqual(resolution.Height, drawBounds.Height);
        }


        [TestMethod]
        public void DoubleWideRoom_BottomRight()
        {
            //arrange
            TileSet tileSet = new TileSet();
            WorldMapCell cell = new WorldMapCell();
            for (int x = 0; x < (WorldMapCellDefinition.NUM_TILES_WIDE * 2); x++)
            {
                for (int y = 0; y < WorldMapCellDefinition.NUM_TILES_HIGH; y++)
                {
                    cell.AddTile(x, y, tileSet, tileSet);
                }
            }

            WorldPosition position = new WorldPosition()
            {
                PositionX = 2020,
                PositionY = 560 
            };

            //act
            Camera camera = new Camera()
            {
                WorldMapCell = cell,
                Position = position,
                Resolution = resolution
            };
            Rectangle drawBounds = camera.GetDrawBounds();

            //assert
            Assert.AreEqual(1024, drawBounds.X);
            Assert.AreEqual(0, drawBounds.Y);
            Assert.AreEqual(resolution.Width, drawBounds.Width);
            Assert.AreEqual(resolution.Height, drawBounds.Height);
        }

    }
}
