﻿using GameMakerAvalonia.Models;
using RawResources.Manager;
using RawResources.Models;
using RawResources.Repository;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;


namespace GameMakerAvalonia.Logic
{
    public class SessionLoader
    {
        private Session session;


        public SessionLoader()
        {
            this.session = null;
        }


        public Session Load(string folder)
        {
            this.session = new Session()
            {
                WorkingDirectory = folder,
                RawContentManager = new DefaultRawContentManager(folder)
            };

            FindNewRawResources(session.RawContentManager.FontRepository, "fonts");
            FindNewRawResources(session.RawContentManager.SongRepository, "music");
            FindNewRawResources(session.RawContentManager.SoundEffectRepository, "soundeffects");
            FindNewRawResources(session.RawContentManager.TextureRepository, "textures");

            FindNewTileSets();

            if(session.RawContentManager.PlayerRepository.GetContent(0) == null)
            {
                PlayerDefinition playerDefinition = new PlayerDefinition()
                {
                    Health = 0,
                    StartPosition = new WorldPosition()
                    {
                        WorldCellX = 0,
                        WorldCellY = 0,
                        WorldMapKey = 0,
                        PositionX = 0,
                        PositionY = 0
                    }
                };

                session.RawContentManager.PlayerRepository.AddContent(playerDefinition);
            }

            return session;
        }


        private void FindNewRawResources(IRawContentRepository<RawResource> repo, string folder)
        {
            IEnumerable<string> files;
            try
            {
                files = Directory.EnumerateFiles(session.WorkingDirectory + Path.DirectorySeparatorChar + "Content" + Path.DirectorySeparatorChar + "bin" + Path.DirectorySeparatorChar + folder, "*", SearchOption.AllDirectories);
            }
            catch (Exception)
            {
                return;
            }

            foreach (string file in files)
            {
                FileInfo fileInfo = new FileInfo(file);

                if (fileInfo.Extension.Equals(".xnb"))
                {
                    string name = fileInfo.FullName.Replace(".xnb", "").Replace(session.WorkingDirectory + Path.DirectorySeparatorChar + "Content" + Path.DirectorySeparatorChar + "bin" + Path.DirectorySeparatorChar, "");

                    //add to list if not exists
                    bool found = false;

                    foreach (RawResource rawResource in repo.GetListOfContent())
                    {
                        if (rawResource.SystemFilePath.Equals(name))
                        {
                            found = true;
                        }
                    }

                    if (found == false)
                    {
                        RawResource newResource = new RawResource()
                        {
                            Key = -1,
                            FilePath = name.Replace(Path.DirectorySeparatorChar, '\\')
                        };

                        repo.AddContent(newResource);
                    }
                }
            }
        }


        private void FindNewTileSets()
        {
            var textureRepository = session.RawContentManager.TextureRepository;
            var tileSetRepository = session.RawContentManager.TileSetRepository;

            //find all used textures
            IList<int> usedTextureKeys = new List<int>();

            foreach (TileSetDefinition tileSetDefinition in tileSetRepository.GetListOfContent())
            {
                if (usedTextureKeys.Contains(tileSetDefinition.TextureKey) == false)
                {
                    usedTextureKeys.Add(tileSetDefinition.TextureKey);
                }
            }

            //find new textures
            int tileWidth = 32;
            int tileHeight = 32;

            foreach (RawResource texture in textureRepository.GetListOfContent())
            {
                if (usedTextureKeys.Contains(texture.Key) == false)
                {
                    if (texture.FilePath.Contains("tilesets"))
                    {
                        Image image = Image.FromFile(session.WorkingDirectory + Path.DirectorySeparatorChar + "Content" + Path.DirectorySeparatorChar + texture.SystemFilePath + ".png");

                        if ((image.Width % tileWidth == 0) && (image.Height % tileHeight == 0))
                        {
                            for (int x = 0; x < image.Width; x += tileWidth)
                            {
                                for (int y = 0; y < image.Height; y += tileHeight)
                                {
                                    TileSetDefinition tileSetDefinition = new TileSetDefinition()
                                    {
                                        Key = -1,
                                        TextureKey = texture.Key,
                                        X = x,
                                        Y = y,
                                        Width = tileWidth,
                                        Height = tileHeight,
                                        Passable = true,
                                        AnimationSequence = new List<int>()
                                    };

                                    tileSetRepository.AddContent(tileSetDefinition);
                                }
                            }
                        }
                    }
                }
            }
        }


    }
}
