﻿using Avalonia.Controls;
using Avalonia.Markup.Xaml;
using GameMakerAvalonia.Models;
using RawResources.Models;
using System.Collections.Generic;


namespace GameMakerAvalonia.Panels
{
    public class FontsPanel : UserControl
    {
        private Session session;
        private IList<RawResource> resources;


        public FontsPanel()
        {
            this.InitializeComponent();
        }


        private void InitializeComponent()
        {
            AvaloniaXamlLoader.Load(this);
        }


        public void SetSession(Session session)
        {
            this.session = session;

            LoadSession();
        }


        private void LoadSession()
        {
            this.resources = session.RawContentManager.FontRepository.GetListOfContent();

            var grid = this.FindControl<DataGrid>("ListGridView");
            grid.Items = resources;
        }


    }
}
