﻿using Avalonia;
using Avalonia.Controls;
using Avalonia.Interactivity;
using Avalonia.Markup.Xaml;
using GameMakerAvalonia.Dialogs;
using GameMakerAvalonia.Models;
using MessageBox.Avalonia.Enums;
using RawResources.Models;
using System;


namespace GameMakerAvalonia.Panels
{
    public class PlayerPanel : UserControl
    {
        private Session session;


        public PlayerPanel()
        {
            this.InitializeComponent();
        }

        private void InitializeComponent()
        {
            AvaloniaXamlLoader.Load(this);

            this.FindControl<Button>("StartLocationSelectButton").Click += StartLocationSelectButton_Click;
            this.FindControl<TextBox>("HealthText").PropertyChanged += HealthText_TextChanged;
        }


        private async void StartLocationSelectButton_Click(object sender, RoutedEventArgs e)
        {
            if (session == null) return;
            PlayerDefinition player = this.session.RawContentManager.PlayerRepository.GetContent(0);
            if (player == null) return;

            WorldPositionSelectDialog dialog = new WorldPositionSelectDialog();
            dialog.SetSession(this.session);
            dialog.SelectedWorldPosition = player.StartPosition.Copy();

            await dialog.ShowDialog((Window)this.VisualRoot);

            ButtonResult result = dialog.DialogResult;

            if (result == ButtonResult.Ok)
            {
                player.StartPosition = dialog.SelectedWorldPosition;

                TextBox startLocationText = this.FindControl<TextBox>("StartLocationText");
                startLocationText.Text = player.StartPosition.ToString();
            }
        }


        private void HealthText_TextChanged(object sender, AvaloniaPropertyChangedEventArgs e)
        {
            if (e.Property.Name.Equals("Text"))
            {
                if (session == null) return;
                PlayerDefinition player = this.session.RawContentManager.PlayerRepository.GetContent(0);
                if (player == null) return;

                TextBox healthText = this.FindControl<TextBox>("HealthText");
                int health = 0;

                if (Int32.TryParse(healthText.Text, out health))
                {
                    player.Health = health;
                }
            }
        }


        public void SetSession(Session session)
        {
            this.session = session;

            LoadPlayer();
        }


        private void LoadPlayer()
        {
            if (session == null) return;
            PlayerDefinition player = this.session.RawContentManager.PlayerRepository.GetContent(0);
            if (player == null) return;

            TextBox healthText = this.FindControl<TextBox>("HealthText");
            healthText.Text = player.Health.ToString();

            TextBox startLocationText = this.FindControl<TextBox>("StartLocationText");
            startLocationText.Text = player.StartPosition.ToString();
        }





    }
}
