﻿using Avalonia.Controls;
using Avalonia.Markup.Xaml;
using Avalonia.Media.Imaging;
using GameMakerAvalonia.Models;
using RawResources.Models;
using System;
using System.Collections.Generic;
using System.IO;

namespace GameMakerAvalonia.Panels
{
    public class TexturesPanel : UserControl
    {
        private Session session;
        private IList<RawResource> resources;


        public TexturesPanel()
        {
            this.InitializeComponent();
        }


        private void InitializeComponent()
        {
            AvaloniaXamlLoader.Load(this);

            this.FindControl<DataGrid>("ListGridView").CurrentCellChanged += ListGridView_CurrentCellChanged;
        }


        public void SetSession(Session session)
        {
            this.session = session;

            LoadSession();
        }


        private void LoadSession()
        {
            this.resources = session.RawContentManager.TextureRepository.GetListOfContent();

            var grid = this.FindControl<DataGrid>("ListGridView");
            grid.Items = resources;
        }


        private void ListGridView_CurrentCellChanged(object sender, EventArgs e)
        {
            var grid = this.FindControl<DataGrid>("ListGridView");
            
            if(grid.SelectedItem != null)
            {
                var image = this.FindControl<Image>("TextureImage");
                RawResource item = (RawResource)grid.SelectedItem;
                string filename = this.session.WorkingDirectory + Path.DirectorySeparatorChar + "Content" + Path.DirectorySeparatorChar + item.SystemFilePath + ".png";

                IBitmap bitmap = new Avalonia.Media.Imaging.Bitmap(filename);
                image.Source = bitmap;
                
            }
        }


    }
}
