﻿using Avalonia;
using Avalonia.Controls;
using Avalonia.Markup.Xaml;
using GameMakerAvalonia.Models;
using GameMakerAvalonia.PreviewPanels;
using RawResources.Models;
using System;
using System.Collections.Generic;


namespace GameMakerAvalonia.Panels
{
    public class TileSetsAnimationPanel : UserControl
    {
        private Session session;
        private IList<RawResource> resources;


        public TileSetsAnimationPanel()
        {
            this.InitializeComponent();
        }


        private void InitializeComponent()
        {
            AvaloniaXamlLoader.Load(this);

            this.FindControl<DataGrid>("ListGridView").CurrentCellChanged += ListGridView_CurrentCellChanged;
            AddEvents();
        }


        private void AddEvents()
        {
            this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel").PropertyChanged += TileSetAnimationsSelectPanel_PropertyChanged;
            this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel2").PropertyChanged += TileSetAnimationsSelectPanel2_PropertyChanged;
            this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel3").PropertyChanged += TileSetAnimationsSelectPanel3_PropertyChanged;
            this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel4").PropertyChanged += TileSetAnimationsSelectPanel4_PropertyChanged;
            this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel5").PropertyChanged += TileSetAnimationsSelectPanel5_PropertyChanged;
        }


        private void RemoveEvents()
        {
            this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel").PropertyChanged -= TileSetAnimationsSelectPanel_PropertyChanged;
            this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel2").PropertyChanged -= TileSetAnimationsSelectPanel2_PropertyChanged;
            this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel3").PropertyChanged -= TileSetAnimationsSelectPanel3_PropertyChanged;
            this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel4").PropertyChanged -= TileSetAnimationsSelectPanel4_PropertyChanged;
            this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel5").PropertyChanged -= TileSetAnimationsSelectPanel5_PropertyChanged;
        }


        public void SetSession(Session session)
        {
            this.session = session;

            LoadSession();
        }


        private void LoadSession()
        {
            var grid = this.FindControl<DataGrid>("ListGridView");

            this.resources = new List<RawResource>();

            foreach (RawResource texture in this.session.RawContentManager.TextureRepository.GetListOfContent())
            {
                bool isUsed = false;

                foreach (TileSetDefinition tileSet in this.session.RawContentManager.TileSetRepository.GetListOfContent())
                {
                    if (tileSet.TextureKey == texture.Key) isUsed = true;
                }

                if (isUsed) this.resources.Add(texture);
            }

            grid.Items = this.resources;
        }


        private void ListGridView_CurrentCellChanged(object sender, EventArgs e)
        {
            var grid = this.FindControl<DataGrid>("ListGridView");

            if (grid.SelectedItem != null)
            {
                RawResource item = (RawResource)grid.SelectedItem;

                var panel1 = this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel");
                var panel2 = this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel2");
                var panel3 = this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel3");
                var panel4 = this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel4");
                var panel5 = this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel5");

                panel1.SetParameters(this.session, item.Key);
                panel2.SetParameters(this.session, item.Key);
                panel3.SetParameters(this.session, item.Key);
                panel4.SetParameters(this.session, item.Key);
                panel5.SetParameters(this.session, item.Key);

                panel1.InvalidateVisual();
                panel2.InvalidateVisual();
                panel3.InvalidateVisual();
                panel4.InvalidateVisual();
                panel5.InvalidateVisual();
            }
        }


        private void TileSetAnimationsSelectPanel_PropertyChanged(object s, AvaloniaPropertyChangedEventArgs e)
        {
            if(e.Property.Name.Equals("SelectedTileSet"))
            {
                var panel1 = this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel");
                var panel2 = this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel2");
                var panel3 = this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel3");
                var panel4 = this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel4");
                var panel5 = this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel5");

                TileSetDefinition selectedTile = panel1.SelectedTileSet;

                //reset
                RemoveEvents();

                panel2.SelectedTileSet = null;
                panel3.SelectedTileSet = null;
                panel4.SelectedTileSet = null;
                panel5.SelectedTileSet = null;

                if (selectedTile != null)
                {
                    //set selections
                    if (selectedTile.AnimationSequence.Count >= 2)
                    {
                        panel2.SelectedTileSet = this.session.RawContentManager.TileSetRepository.GetContent(selectedTile.AnimationSequence[1]);
                    }

                    if (selectedTile.AnimationSequence.Count >= 3)
                    {
                        panel3.SelectedTileSet = this.session.RawContentManager.TileSetRepository.GetContent(selectedTile.AnimationSequence[2]);
                    }

                    if (selectedTile.AnimationSequence.Count >= 4)
                    {
                        panel4.SelectedTileSet = this.session.RawContentManager.TileSetRepository.GetContent(selectedTile.AnimationSequence[3]);
                    }

                    if (selectedTile.AnimationSequence.Count >= 5)
                    {
                        panel4.SelectedTileSet = this.session.RawContentManager.TileSetRepository.GetContent(selectedTile.AnimationSequence[4]);
                    }
                }

                AddEvents();

                panel2.InvalidateVisual();
                panel3.InvalidateVisual();
                panel4.InvalidateVisual();
                panel5.InvalidateVisual();
            }
        }


        private void TileSetAnimationsSelectPanel2_PropertyChanged(object s, AvaloniaPropertyChangedEventArgs e)
        {
            if (e.Property.Name.Equals("SelectedTileSet")) TileSetAnimationsSet();
        }


        private void TileSetAnimationsSelectPanel3_PropertyChanged(object s, AvaloniaPropertyChangedEventArgs e)
        {
            if (e.Property.Name.Equals("SelectedTileSet")) TileSetAnimationsSet();
        }


        private void TileSetAnimationsSelectPanel4_PropertyChanged(object s, AvaloniaPropertyChangedEventArgs e)
        {
            if (e.Property.Name.Equals("SelectedTileSet")) TileSetAnimationsSet();
        }


        private void TileSetAnimationsSelectPanel5_PropertyChanged(object s, AvaloniaPropertyChangedEventArgs e)
        {
            if (e.Property.Name.Equals("SelectedTileSet")) TileSetAnimationsSet();
        }


        private void TileSetAnimationsSet()
        {
            var panel1 = this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel");
            var panel2 = this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel2");
            var panel3 = this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel3");
            var panel4 = this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel4");
            var panel5 = this.FindControl<TileSetPreviewPanel>("TileSetAnimationsSelectPanel5");

            TileSetDefinition tileSetDefinition = panel1.SelectedTileSet;

            if (tileSetDefinition == null) return;

            Int32 t1 = panel1.SelectedTileSet != null ? panel1.SelectedTileSet.Key : -1;
            Int32 t2 = panel2.SelectedTileSet != null ? panel2.SelectedTileSet.Key : -1;
            Int32 t3 = panel3.SelectedTileSet != null ? panel3.SelectedTileSet.Key : -1;
            Int32 t4 = panel4.SelectedTileSet != null ? panel4.SelectedTileSet.Key : -1;
            Int32 t5 = panel5.SelectedTileSet != null ? panel5.SelectedTileSet.Key : -1;

            tileSetDefinition.SetAnimationSequence(t1, t2, t3, t4, t5);
        }

    }
}
