﻿using GameResources.Logic.Physics;
using GameResources.Models.Game;
using GameResources.Models.World;
using Microsoft.Xna.Framework;
using System.Collections.Generic;


namespace GameResources.Logic.EnemyMotion
{
    public class CounterClockWiseCrawling : IEnemyMotion
    {
        private readonly Enemy enemy;
        private readonly int speed;
        private int xDirection;
        private int yDirection;


        public CounterClockWiseCrawling(Enemy enemy)
        {
            this.enemy = enemy;
            this.speed = 1;

            this.xDirection = 0;
            this.yDirection = 0;
        }


        public void Do(long ticks, GameState gameState)
        {
            WorldMapCell activeMapCell = gameState.GetActiveWorldMapCell();
            CollisionDetection collisionDetection = new CollisionDetection(enemy, activeMapCell, gameState);

            for (int i = 0; i < 2; i++)
            {
                UpdateDirection(collisionDetection);

                enemy.Motion.VelocityX = this.xDirection * speed;
                enemy.Motion.VelocityY = this.yDirection * speed;

                PhysicsEngine physics = new PhysicsEngine(enemy, activeMapCell, gameState, false);
                physics.IgnoreObjects.Add(gameState.Player);
                physics.Update();
            }
        }


        private void UpdateDirection(CollisionDetection collisionDetection)
        {
            Point direction = new Point(0, 0);

            List<Point> directions = new List<Point>();
            directions.Add(new Point(-1, -1));
            directions.Add(new Point(0, -1));
            directions.Add(new Point(1, -1));
            directions.Add(new Point(-1, 0));
            directions.Add(new Point(1, 0));
            directions.Add(new Point(-1, 1));
            directions.Add(new Point(0, 1));
            directions.Add(new Point(1, 1));

            List<bool> walls = new List<bool>();
            
            //find current walls
            foreach (Point d in directions)
            {
                bool pass = (collisionDetection.HasCollidedInWorldAtPosition(enemy.Position.PositionX + d.X, enemy.Position.PositionY + d.Y));

                walls.Add(pass);
            }

            //inside corners
            if (walls[6] && walls[4] && !walls[3]) direction = new Point(-1, 0);
            else if (walls[3] && walls[6] && !walls[1]) direction = new Point(0, -1);
            else if (walls[1] && walls[3] && !walls[4]) direction = new Point(1, 0);
            else if (walls[4] && walls[1] && !walls[6]) direction = new Point(0, 1);
            //basic 3 walls
            else if (walls[5] && walls[6]) direction = new Point(-1, 0);
            else if (walls[1] && walls[2]) direction = new Point(1, 0);
            else if (walls[3] && walls[0]) direction = new Point(0, -1);
            else if (walls[7] && walls[4]) direction = new Point(0, 1);
            //approaching outside corners
            else if (walls[0] && walls[1]) direction = new Point(1, 0);
            else if (walls[3] && walls[5]) direction = new Point(0, -1);
            else if (walls[6] && walls[7]) direction = new Point(-1, 0);
            else if (walls[2] && walls[4]) direction = new Point(0, 1);
            //outside corners
            else if (walls[0]) direction = new Point(0, -1);
            else if (walls[2]) direction = new Point(1, 0);
            else if (walls[5]) direction = new Point(-1, 0);
            else if (walls[7]) direction = new Point(0, 1); 

            this.xDirection = direction.X;
            this.yDirection = direction.Y;
        }

    }
}
