﻿using GameResources.Logic.Physics;
using GameResources.Models.Game;
using GameResources.Models.World;
using System;


namespace GameResources.Logic.EnemyMotion
{
    public class HopEnemyMotion : IEnemyMotion
    {
        private Enemy enemy;

        private long jumpStart;
        private long jumpEnd;
        private bool isJumping;
        private int xDirection;

        public HopEnemyMotion(Enemy enemy)
        {
            this.enemy = enemy;

            isJumping = false;
            xDirection = PickDirection();

            jumpStart = 0;
            jumpEnd = 0;
        }


        public void Do(long ticks, GameState gameState)
        {
            jumpStart += ticks;
            jumpEnd += ticks;


            if ((isJumping == false) && (jumpEnd > (TimeSpan.TicksPerSecond * 1)))
            {
                if (enemy.Motion.IsOnGround)
                {
                    isJumping = true;
                    jumpStart = 0;
                }
            }
            else if ((isJumping) && (jumpStart > (TimeSpan.TicksPerSecond * 0.1)))
            {
                isJumping = false;
                jumpEnd = 0;
            }

            if (isJumping)
            {
                this.enemy.Motion.VelocityY = -6;
            }
            else
            {
                this.enemy.Motion.VelocityY += 1;

                if (this.enemy.Motion.VelocityY > 10) this.enemy.Motion.VelocityY = 10;
            }

            if (enemy.Motion.IsOnGround)
            {
                this.enemy.Motion.VelocityX = 0;
                xDirection = PickDirection();
            }
            else this.enemy.Motion.VelocityX = xDirection * 3;
            
            PhysicsEngine physics = new PhysicsEngine(enemy, gameState.GetActiveWorldMapCell(), gameState, false);
            physics.IgnoreObjects.Add(gameState.Player);
            physics.Update();
        }


        private int PickDirection()
        {
            Random rand = new Random();

            if (rand.Next(2) == 0) return -1;
            else return 1;
        }

    }
}
