﻿using GameResources.Logic.Physics;
using GameResources.Models.Game;
using GameResources.Models.World;
using System;


namespace GameResources.Logic.EnemyMotion
{
    public class WobblyFlyingEnemyMotion : IEnemyMotion
    {
        private Enemy enemy;
        private int xDirection;
        private int yDirection;
        private long lastYDirectionChange;


        public WobblyFlyingEnemyMotion(Enemy enemy)
        {
            this.enemy = enemy;
            this.xDirection = 1;
            this.yDirection = 1;

            lastYDirectionChange = 0;
        }


        public void Do(long ticks, GameState gameState)
        {
            lastYDirectionChange += ticks;

            enemy.Motion.VelocityX = 4 * xDirection;
            enemy.Motion.VelocityY = 3 * yDirection;

            PhysicsEngine physics = new PhysicsEngine(enemy, gameState.GetActiveWorldMapCell(), gameState, false);
            physics.IgnoreObjects.Add(gameState.Player);
            physics.Update();

            if (enemy.Motion.VelocityX == 0) xDirection = xDirection * -1;
            
            if (lastYDirectionChange > (TimeSpan.TicksPerSecond * 0.5))
            {
                yDirection = yDirection * -1;
                lastYDirectionChange = 0;
            }
        }

    }
}
