﻿using GameResources.Models.Game;
using System;
using System.IO;
using System.IO.IsolatedStorage;
using System.Text.Json;


namespace GameResources.Logic.Game
{
    public class GameSaver
    {

        public GameSaver()
        {

        }


        public bool Save(GameState gameState)
        {
            IsolatedStorageFile savegameStorage = IsolatedStorageFile.GetUserStoreForAssembly();
            IsolatedStorageFileStream isolatedFileStream = null;
            string filename = "metroid-" + gameState.GameSlot +  ".sav";

            try
            {
                isolatedFileStream = savegameStorage.OpenFile(filename, System.IO.FileMode.Create);
            }
            catch (Exception)
            {
                return false;
            }

            if (isolatedFileStream != null)
            {
                StreamWriter writer = new StreamWriter(isolatedFileStream);

                SaveContainer container = new SaveContainer()
                {
                    PlayerInventory = gameState.Player.Inventory,
                    PlayerPosition = gameState.Player.Position,
                    PlayerStats = gameState.Player.CharacterStats,
                    VariableState = gameState.VariableState,
                    PickedUpItems = gameState.PickedUpItems,
                    MapHistory = gameState.MapHistory
                };

                string json = JsonSerializer.Serialize(container);

                writer.Write(json);

                writer.Close();
                isolatedFileStream.Close();
            }

            return true;
        }


    }
}
