﻿using GameResources.Manager;
using GameResources.Models.Characters;
using GameResources.Models.Game;
using GameResources.Models.Weapons;
using Microsoft.Xna.Framework;
using RawResources.Models;


namespace GameResources.Logic.Weapons
{
    public class BasicShooter
    {
        private readonly GameState gameState;
        private readonly IGameContentManager gameContentManager;

        private readonly int spazerSpacing = 20;
        private readonly int speed = 16;


        public BasicShooter(GameState gameState, IGameContentManager gameContentManager)
        {
            this.gameState = gameState;
            this.gameContentManager = gameContentManager;
        }


        public void Do(IBattleObject caster, WorldPosition launchPosition, Point direction, WeaponModifier weaponModifier)
        {
            BasicShot shot = new BasicShot(gameState, gameContentManager, caster, weaponModifier);
            shot.Position = launchPosition.Copy();
            shot.Position.PositionX += GetLaunchOffsetX(direction, weaponModifier);
            shot.Position.PositionY += GetLaunchOffsetY(direction, weaponModifier);
            shot.Motion.VelocityX = direction.X * speed;
            shot.Motion.VelocityY = direction.Y * speed;
            gameState.ActiveWeaponSprites.Add(shot);

            if(weaponModifier.IsSpazer)
            {
                //left
                shot = new BasicShot(gameState, gameContentManager, caster, weaponModifier);
                shot.Position = launchPosition.Copy();
                shot.Position.PositionX += GetLaunchOffsetX(direction, weaponModifier);
                shot.Position.PositionY += GetLaunchOffsetY(direction, weaponModifier);
                shot.Position.PositionX += GetSpazerOffsetX(direction, 1);
                shot.Position.PositionY += GetSpazerOffsetY(direction, 1);
                shot.Motion.VelocityX = direction.X * speed;
                shot.Motion.VelocityY = direction.Y * speed;
                gameState.ActiveWeaponSprites.Add(shot);

                //right
                shot = new BasicShot(gameState, gameContentManager, caster, weaponModifier);
                shot.Position = launchPosition.Copy();
                shot.Position.PositionX += GetLaunchOffsetX(direction, weaponModifier);
                shot.Position.PositionY += GetLaunchOffsetY(direction, weaponModifier);
                shot.Position.PositionX += GetSpazerOffsetX(direction, 2);
                shot.Position.PositionY += GetSpazerOffsetY(direction, 2);
                shot.Motion.VelocityX = direction.X * speed;
                shot.Motion.VelocityY = direction.Y * speed;
                gameState.ActiveWeaponSprites.Add(shot);
            }

            if(weaponModifier.IsCharged) gameContentManager.SoundEffectRepository.GetContentByName(@"soundeffects\Basic Charged Shot").Play();
            else if (weaponModifier.IsIce) gameContentManager.SoundEffectRepository.GetContentByName(@"soundeffects\Ice Beam Shot").Play();
            else if (weaponModifier.IsPlasma) gameContentManager.SoundEffectRepository.GetContentByName(@"soundeffects\Plasma Beam Shot").Play();
            else if (weaponModifier.IsWave) gameContentManager.SoundEffectRepository.GetContentByName(@"soundeffects\Wide Beam Shot").Play();
            else gameContentManager.SoundEffectRepository.GetContentByName(@"soundeffects\Basic Shot").Play();
        }


        private int GetLaunchOffsetX(Point direction, WeaponModifier weaponModifier)
        {
            if (weaponModifier.IsSpazer && direction.X != 0) return direction.X * 2;
            else if (weaponModifier.IsPlasma && direction.X != 0) return direction.X * 2;
            else return 0;
        }


        private int GetLaunchOffsetY(Point direction, WeaponModifier weaponModifier)
        {
            if (weaponModifier.IsSpazer && direction.Y != 0) return direction.Y * 2;
            else if (weaponModifier.IsPlasma && direction.Y != 0) return direction.Y * 2;
            return 0;
        }


        private int GetSpazerOffsetX(Point direction, int beamNum)
        {
            bool doOffset = false;
            int sign = 1;

            if (direction.X == 0) doOffset = true;
            else if (direction.X != 0 && direction.Y != 0) doOffset = true;
            
            if(doOffset)
            {
                if (beamNum == 1) sign = -1;

                if (direction.X == direction.Y) sign = sign * -1;

                return sign * spazerSpacing;
            }
            else
            {
                return 0;
            }
        }


        private int GetSpazerOffsetY(Point direction, int beamNum)
        {
            bool doOffset = false;
            int sign = 1;

            if (direction.Y == 0) doOffset = true;
            else if (direction.X != 0 && direction.Y != 0) doOffset = true;

            if (doOffset)
            {
                if (beamNum == 1) sign = -1;
                if (direction.X == direction.Y) sign = sign * 1;

                return sign * spazerSpacing;
            }
            else
            {
                return 0;
            }
        }


    }
}
