﻿using GameResources.Manager;
using GameResources.Models.Characters;
using GameResources.Models.Game;
using GameResources.Models.Weapons;
using Microsoft.Xna.Framework;
using RawResources.Models;


namespace GameResources.Logic.Weapons
{
    public class MissileShooter
    {
        private readonly GameState gameState;
        private readonly IGameContentManager gameContentManager;


        public MissileShooter(GameState gameState, IGameContentManager gameContentManager)
        {
            this.gameState = gameState;
            this.gameContentManager = gameContentManager;
        }


        public void Do(IBattleObject caster, WorldPosition launchPosition, Point direction)
        {
            MissileShot shot = new MissileShot(gameState, gameContentManager, caster);
            int speed = 8;

            shot.Position = launchPosition.Copy();
            shot.Motion.VelocityX = direction.X * speed;
            shot.Motion.VelocityY = direction.Y * speed;

            gameState.ActiveWeaponSprites.Add(shot);

            gameContentManager.SoundEffectRepository.GetContentByName(@"soundeffects\Missile Shoot").Play();
        }

    }
}
