﻿using GameResources.Manager;
using GameResources.Models.World;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using RawResources.Models;
using System;


namespace GameResources.Models.Effects
{
    public class ItemPickupEffect : IEffect
    {
        public bool IsExpired { get; set; }
        private readonly Texture2D backgroundTexture;
        private readonly Texture2D itemTexture;
        private readonly string message;
        private readonly SpriteFont font;
        private readonly double maxDisplayTime;
        private readonly WorldPosition position;
        private readonly int maxPositionX;
        private long createTime;


        public ItemPickupEffect(IGameContentManager gameContentManager, Item item, WorldPosition position, WorldMapCell worldMapCell)
        {
            this.backgroundTexture = gameContentManager.TextureRepository.GetContentByName(@"textures\white");
            this.font = gameContentManager.FontRepository.GetContentByName(@"fonts\Normal");
            
            this.itemTexture = item.GetDisplayTexture();
            this.message = item.GetDisplayMessage();
            this.position = position;
            
            this.maxPositionX = TileSet.DRAW_SIZE * (worldMapCell.GetMaxTileX() / worldMapCell.WorldMapWidth);

            this.IsExpired = false;
            this.maxDisplayTime = 6;

            this.createTime = 0;
        }


        public void Draw(SpriteBatch spriteBatch, long dx, long dy)
        {
            Vector2 messageLength = font.MeasureString(message);

            int sx = (int)(this.position.PositionX - dx - ((int)messageLength.X / 2) - 48);
            int sy = (int)(this.position.PositionY - dy - 192);
            int sw = (int)messageLength.X + 96;
            int sh = 64;

            if ((sx + sw) > maxPositionX) sx = maxPositionX - sw;
            else if (sx < 0) sx = 0;

            if (sy < 0) sy = 0;

            Rectangle rect = new Rectangle(sx, sy, sw, sh);
            spriteBatch.Draw(backgroundTexture, rect, Color.Black);

            rect = new Rectangle(sx + 16, sy + 16, 32, 32);
            spriteBatch.Draw(itemTexture, rect, Color.White);

            spriteBatch.DrawString(font, message, new Vector2(sx + 32 + 32, sy + messageLength.Y - 18), Color.White);
        }


        public void Update(long ticks)
        {
            createTime += ticks;

            if (createTime >= (TimeSpan.TicksPerSecond * maxDisplayTime))
            {
                IsExpired = true;
            }
        }

    }
}
