﻿using GameResources.Models.World;

namespace GameResources.Models.Game
{
    public class MapHistoryEntry
    {
        public int WorldKey { get; set; }
        public int WorldCellX { get; set; }
        public int WorldCellY { get; set; }


        public MapHistoryEntry()
        {

        }


        public MapHistoryEntry(WorldMapCell worldMapCell)
        {
            this.WorldKey = worldMapCell.WorldKey;
            this.WorldCellX = worldMapCell.WorldMapX;
            this.WorldCellY = worldMapCell.WorldMapY;
        }


        public override bool Equals(object e)
        {
            if(e.GetType() == typeof(MapHistoryEntry))
            {
                MapHistoryEntry entry = (MapHistoryEntry)e;

                return ((entry.WorldKey == this.WorldKey) && (entry.WorldCellX == this.WorldCellX) && (entry.WorldCellY == this.WorldCellY));
            }
            else
            {
                return false;
            }
        }


        public override int GetHashCode()
        {
            return base.GetHashCode();
        }
    }
}
