﻿using System.Collections.Generic;


namespace GameResources.Models.Game
{
    public class VariableState
    {
        public Dictionary<string, bool> Variables { get;  set; }

        public VariableState()
        {
            this.Variables = new Dictionary<string, bool>();
        }


        public void SetVariable(string variable, bool state)
        {
            if (this.Variables.ContainsKey(variable))
            {
                this.Variables[variable] = state;
            }
            else
            {
                this.Variables.Add(variable, state);
            }
        }


        public bool GetVariable(string variable)
        {
            bool result = false;

            if (this.Variables.ContainsKey(variable))
            {
                result = this.Variables[variable];
            }

            return result;
        }


    }
}
