﻿using GameResources.Manager;
using GameResources.Models.Game;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using RawResources.Models;


namespace GameResources.Models.Physics
{
    public interface IMoveableObject
    {
        WorldPosition Position { get; set; }
        Motion Motion { get; set; }
        Rectangle GetCollisionAreaAtPosition(long x, long y);
        Rectangle GetCurrentCollisionArea();
        void Update(GameState gameState, IGameContentManager gameContentManager, long ticks);
        void Draw(SpriteBatch spriteBatch, long dx, long dy);
    }
}
