﻿using GameResources.Models.Game;
using GameResources.Repository;
using Microsoft.Xna.Framework.Audio;
using System;


namespace GameResources.Models.Samus
{
    public class PlayerAttackState
    {
        public enum State
        {
            Nothing,
            Charging,
            Charged,
            NotCharged,
            Shoot,
            ShootCharged
        }


        public State Current { get; set; }
        public double MaxChargingTime { get; set; }
        public double ChargingTime { get; set; }
        private long chargeStart;
        private SoundEffectInstance chargingSound;


        public PlayerAttackState()
        {
            this.Current = State.Nothing;

            this.chargeStart = 0;
            this.ChargingTime = 0;
            this.MaxChargingTime = 1.5;
        }


        public void Update(InputMap inputMap, long ticks, PlayerInventory inventory, PlayerMotionState motionState, IGameNamedContentRepository<SoundEffect> soundEffectRepository)
        {
            chargeStart += ticks;

            if (Current == State.Nothing)
            {
                if (inputMap.Shoot && inventory.HasChargeBeam == false) Current = State.NotCharged;
                else if (inputMap.Shoot && inventory.HasChargeBeam && inventory.SelectedWeapon == PlayerInventory.Weapons.Normal && motionState.IsBall() == false)
                {
                    chargeStart = 0;
                    Current = State.Charging;
                }
                else if (inputMap.Shoot && (inventory.SelectedWeapon != PlayerInventory.Weapons.Normal || motionState.IsBall())) Current = State.NotCharged;
            }
            else if (Current == State.NotCharged)
            {
                if (inputMap.Shoot == false) Current = State.Shoot;
            }
            else if (Current == State.Charging)
            {
                this.ChargingTime = (double)chargeStart / TimeSpan.TicksPerSecond;

                if (chargingSound==null && (this.ChargingTime >= 0.2))
                {
                    StartChargingSound(soundEffectRepository);
                }

                if (this.ChargingTime >= this.MaxChargingTime)
                {
                    Current = State.Charged;
                    StopChargingSound();
                }
                else if (inputMap.Shoot == false)
                {
                    Current = State.Shoot;
                    StopChargingSound();
                }
            }
            else if (Current == State.Charged)
            {
                this.ChargingTime = chargeStart * TimeSpan.TicksPerSecond;

                if (inputMap.Shoot == false) Current = State.ShootCharged;
            }
            else if (Current == State.Shoot)
            {
                Current = State.Nothing;
            }
            else if (Current == State.ShootCharged)
            {
                Current = State.Nothing;
            }
        }


        private void StartChargingSound(IGameNamedContentRepository<SoundEffect> soundEffectRepository)
        {
            chargingSound = soundEffectRepository.GetContentByName(@"soundeffects\Basic Charge Loop").CreateInstance();
            chargingSound.IsLooped = true;
            chargingSound.Play();
        }


        private void StopChargingSound()
        {
            if(chargingSound != null)
            {
                chargingSound.Stop();
                chargingSound = null;
            }
        }


    }
}
