﻿using GameResources.Logic.Weapons;
using GameResources.Manager;
using GameResources.Models.Characters;
using GameResources.Models.Game;
using GameResources.Models.Physics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using RawResources.Models;
using System;
using System.Collections.Generic;


namespace GameResources.Models.Weapons
{
    public class BombExplosion : IWeaponSprite
    {
        public WorldPosition Position { get; set; }
        public Motion Motion { get; set; }
        public bool IsExpired { get; set; }
        public DamageType DamageType { get; private set; }
        public WeaponModifier WeaponModifier { get; set; }
        public int Damage { get; private set; }

        private readonly IGameContentManager gameContentManager;
        private readonly int size;
        private readonly IList<Texture2D> textures;
        private readonly GameState gameState;
        private int activeTexture;
        private readonly IBattleObject caster;

        private long lastAnimiationTime;
        private long creationTime;


        public BombExplosion(GameState gameState, IGameContentManager gameContentManager, IBattleObject caster)
        {
            this.gameState = gameState;
            this.gameContentManager = gameContentManager;

            this.textures = new List<Texture2D>();
            this.textures.Add(gameContentManager.TextureRepository.GetContentByName(@"textures\effects\bomb-explosion-1"));
            this.textures.Add(gameContentManager.TextureRepository.GetContentByName(@"textures\effects\bomb-explosion-2"));
            this.textures.Add(gameContentManager.TextureRepository.GetContentByName(@"textures\effects\bomb-explosion-3"));
            this.textures.Add(gameContentManager.TextureRepository.GetContentByName(@"textures\effects\bomb-explosion-4"));
            this.textures.Add(gameContentManager.TextureRepository.GetContentByName(@"textures\effects\bomb-explosion-5"));
            this.activeTexture = 0;

            this.size = 64;
            this.caster = caster;
            this.Damage = 33;

            this.IsExpired = false;
            this.Motion = new Motion();
            this.Position = new WorldPosition();
            this.DamageType = DamageType.Bomb;
            this.WeaponModifier = new WeaponModifier();

            this.lastAnimiationTime = 0;
            this.creationTime = 0;
        }


        public void Draw(SpriteBatch spriteBatch, long dx, long dy)
        {
            Rectangle rect = new Rectangle((int)(this.Position.PositionX - dx - (size / 2)), (int)(this.Position.PositionY - dy - (size / 2)), size, size);

            spriteBatch.Draw(this.textures[activeTexture], rect, Color.White);
        }


        public void Update(GameState gameState, IGameContentManager gameContentManager, long ticks)
        {
            //damage
            if (creationTime == 0)
            {
                //detect hit and damage enemy
                DetectCollisionWithDamagables();
            }

            creationTime += ticks;
            lastAnimiationTime += ticks;

            //animate
            if (lastAnimiationTime > (TimeSpan.TicksPerSecond * 0.05))
            {
                activeTexture++;
                if (activeTexture >= textures.Count) activeTexture = textures.Count - 1;

                lastAnimiationTime = 0;
            }

            //expire sprite
            if (creationTime >= (TimeSpan.TicksPerSecond * 0.25))
            {
                IsExpired = true;
            }
        }


        public Rectangle GetCurrentCollisionArea()
        {
            return GetCollisionAreaAtPosition(Position.PositionX, Position.PositionY);
        }


        public Rectangle GetCollisionAreaAtPosition(long x, long y)
        {
            Rectangle area = new Rectangle((int)(x - (size/2)), (int)(y - (size/2)), size, size);

            return area;
        }


        private bool DetectCollisionWithDamagables()
        {
            WeaponCollisionDetection weaponCollisionDetection = new WeaponCollisionDetection(gameState, gameContentManager, this, null);
            return weaponCollisionDetection.DealWithCollision();
        }

    }
}
