﻿using GameResources.Logic.Weapons;
using GameResources.Manager;
using GameResources.Models.Characters;
using GameResources.Models.Game;
using GameResources.Models.Physics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using RawResources.Models;
using System;


namespace GameResources.Models.Weapons
{
    public class SuperBombExplosion : IWeaponSprite
    {
        public WorldPosition Position { get; set; }
        public Motion Motion { get; set; }
        public bool IsExpired { get; set; }
        public DamageType DamageType { get; private set; }
        public WeaponModifier WeaponModifier { get; set; }
        public int Damage { get; private set; }

        private readonly IGameContentManager gameContentManager;
        private int size;
        private readonly GameState gameState;
        private readonly Texture2D texture;
        private readonly IBattleObject caster;
        private bool hasDamaged;

        private long lastAnimiationTime;
        private long creationTime;


        public SuperBombExplosion(GameState gameState, IGameContentManager gameContentManager, IBattleObject caster)
        {
            this.gameState = gameState;
            this.gameContentManager = gameContentManager;

            this.texture = gameContentManager.TextureRepository.GetContentByName(@"textures\effects\superbomb-explosion");
            
            this.size = 1;
            this.caster = caster;
            this.Damage = 200;

            this.IsExpired = false;
            this.Motion = new Motion();
            this.Position = new WorldPosition();
            this.DamageType = DamageType.SuperBomb;
            this.hasDamaged = false;
            this.WeaponModifier = new WeaponModifier();

            this.creationTime = 0;
            this.lastAnimiationTime = 0;
        }


        public void Draw(SpriteBatch spriteBatch, long dx, long dy)
        {
            Rectangle rect = new Rectangle((int)(this.Position.PositionX - dx - (size / 2)), (int)(this.Position.PositionY - dy - (size / 2)), size, size);

            spriteBatch.Draw(this.texture, rect, Color.White);
        }


        public void Update(GameState gameState, IGameContentManager gameContentManager, long ticks)
        {
            creationTime += ticks;
            lastAnimiationTime += ticks;

            //grow radius
            if (lastAnimiationTime > (TimeSpan.TicksPerSecond * 0.08))
            {
                size *= 2;

                lastAnimiationTime = 0;
            }

            //damage
            if(creationTime >= (TimeSpan.TicksPerSecond * 0.75))
            {
                if (hasDamaged == false)
                {
                    //detect hit and damage enemy
                    DetectCollisionWithDamagables();

                    hasDamaged = true;
                }
            }

            //expire sprite
            if (creationTime >= (TimeSpan.TicksPerSecond * 1.5))
            {
                IsExpired = true;
            }
        }


        public Rectangle GetCurrentCollisionArea()
        {
            return GetCollisionAreaAtPosition(Position.PositionX, Position.PositionY);
        }


        public Rectangle GetCollisionAreaAtPosition(long x, long y)
        {
            int blastDiameter = 2048;
            Rectangle area = new Rectangle((int)(x - (blastDiameter / 2)), (int)(y - (blastDiameter / 2)), blastDiameter, blastDiameter);

            return area;
        }


        private bool DetectCollisionWithDamagables()
        {
            WeaponCollisionDetection weaponCollisionDetection = new WeaponCollisionDetection(gameState, gameContentManager, this, null);
            return weaponCollisionDetection.DealWithCollision();
        }

    }
}
