﻿using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Media;
using RawResources.Models;
using System;
using System.Collections.Generic;


namespace GameResources.Models.World
{
    public class WorldMapCell
    {
        public int WorldMapX { get; set; }
        public int WorldMapY { get; set; }
        public int WorldMapWidth { get; set; }
        public int WorldMapHeight { get; set; }
        public int WorldKey { get; set; }
        public Song Song { get; set; }
        public bool IsHeated { get; set; }
        public int WaterLevel { get; set; }
        public IDictionary<int, IDictionary<int, TileSet>> TileSetsLayer1 { get; }
        public IDictionary<int, IDictionary<int, TileSet>> TileSetsLayer2 { get; }
        public IList<DestructableBlockPlacementDefinition> DestructableBlockPlacements { get; set; }
        public IList<DoorPlacementDefinition> DoorPlacements { get; set; }
        public IList<TeleporterDefinition> TeleporterPlacements { get; set; }
        public IList<ItemPlacementDefinition> ItemPlacements { get; set; }
        public IList<SaverDefinition> SaverPlacements { get; set; }
        public IList<VictoryDefinition> VictoryPlacements { get; set; }
        public IList<EnemyPlacementDefinition> EnemyPlacements { get; set; }
        public Texture2D ParallaxBackground { get; set; }

        private long lastFrameChange;

        private int maxX;
        private int maxY;


        public WorldMapCell()
        {
            TileSetsLayer1 = new Dictionary<int, IDictionary<int, TileSet>>();
            TileSetsLayer2 = new Dictionary<int, IDictionary<int, TileSet>>();
            DestructableBlockPlacements = new List<DestructableBlockPlacementDefinition>();
            DoorPlacements = new List<DoorPlacementDefinition>();
            TeleporterPlacements = new List<TeleporterDefinition>();
            ItemPlacements = new List<ItemPlacementDefinition>();
            SaverPlacements = new List<SaverDefinition>();
            VictoryPlacements = new List<VictoryDefinition>();
            maxX = 0;
            maxY = 0;
            lastFrameChange = 0;
        }


        public void AddTile(int x, int y, TileSet tile1, TileSet tile2)
        {
            if (TileSetsLayer1.ContainsKey(x) == false) TileSetsLayer1.Add(x, new Dictionary<int, TileSet>());
            if (TileSetsLayer2.ContainsKey(x) == false) TileSetsLayer2.Add(x, new Dictionary<int, TileSet>());

            TileSetsLayer1[x].Add(y, tile1);
            TileSetsLayer2[x].Add(y, tile2);

            if (x > maxX) maxX = x;
            if (y > maxY) maxY = y;
        }


        public int GetMaxTileX()
        {
            return maxX + 1;
        }


        public int GetMaxTileY()
        {
            return maxY + 1;
        }


        public void UpdateTiles(long ticks)
        {
            lastFrameChange += ticks;

            if (lastFrameChange >= (TimeSpan.TicksPerSecond * 0.5))
            {
                lastFrameChange = 0;

                IList<TileSet> tileSets = new List<TileSet>();
                int maxX = GetMaxTileX();
                int maxY = GetMaxTileY();

                //gather all unique tiles
                for (int x = 0; x < maxX; x++)
                {
                    for (int y = 0; y < maxY; y++)
                    {
                        if (TileSetsLayer1[x][y] != null && tileSets.Contains(TileSetsLayer1[x][y]) == false) tileSets.Add(TileSetsLayer1[x][y]);
                        if (TileSetsLayer2[x][y] != null && tileSets.Contains(TileSetsLayer2[x][y]) == false) tileSets.Add(TileSetsLayer2[x][y]);
                    }
                }

                //update
                for(int i = 0; i < tileSets.Count; i++)
                {
                    TileSet tileSet = tileSets[i];

                    tileSet.Update();
                }
            }
        }


        public bool HasSave()
        {
            return (this.SaverPlacements.Count > 0);
        }


    }
}
