﻿using GameResources.Logic.EnemyMotion;
using GameResources.Models.World;
using Microsoft.Xna.Framework.Graphics;
using RawResources.Models;
using RawResources.Repository;


namespace GameResources.Repository
{
    public class DirectEnemyRepository : IGameContentRepository<Enemy>
    {
        private readonly IRawContentRepository<EnemyDefinition> enemyRepository;
        private readonly IGameNamedContentRepository<Texture2D> textureRepository;


        public DirectEnemyRepository(IRawContentRepository<EnemyDefinition> enemyRepository, IGameNamedContentRepository<Texture2D> textureRepository)
        {
            this.enemyRepository = enemyRepository;
            this.textureRepository = textureRepository;
        }


        public Enemy GetContentByKey(int key)
        {
            EnemyDefinition definition = this.enemyRepository.GetContent(key);
            if (definition == null) return null;

            Enemy enemy = new Enemy()
            {
                Key = definition.Key,
                Name = definition.Name,
                IsScrewable = definition.IsScrewable,
                OnlyShowIfVariableIsFalse = definition.OnlyShowIfVariableIsFalse,
                SetVariableToTrueUponDeath = definition.SetVariableToTrueUponDeath,
                Attack = definition.Attack,
                IsBombable = definition.IsBombable,
                IsFreezeable = definition.IsFreezeable,
                IsBoss = definition.IsBoss,
                IsImmediatelyFreezable = definition.IsImmediatelyFreezable,
                IsExplosive = definition.IsExplosive,
                CanShoot = definition.CanShoot,
                EnemyKeyForShooting = definition.EnemyKeyForShooting,
                ShootSpeed = definition.ShootSpeed,
                ItemDropChance = definition.ItemDropChance
            };

            enemy.CharacterStats.Health = definition.Health;
            enemy.CharacterStats.MaximumHealth = definition.Health;
            enemy.Textures.Add(textureRepository.GetContentByKey(definition.TextureKey1));
            enemy.Textures.Add(textureRepository.GetContentByKey(definition.TextureKey2));

            //set enemy motion
            if (definition.MotionType == EnemyMotionType.Flying) enemy.MotionType = new FlyingEnemyMotion(enemy);
            else if (definition.MotionType == EnemyMotionType.WobblyFlying) enemy.MotionType = new WobblyFlyingEnemyMotion(enemy);
            else if (definition.MotionType == EnemyMotionType.Bounce) enemy.MotionType = new BounceEnemyMotion(enemy);
            else if (definition.MotionType == EnemyMotionType.CounterClockWiseCrawling) enemy.MotionType = new CounterClockWiseCrawling(enemy);
            else if (definition.MotionType == EnemyMotionType.ClockWiseCrawling) enemy.MotionType = new ClockWiseCrawling(enemy);
            else if (definition.MotionType == EnemyMotionType.Jumper) enemy.MotionType = new JumperEnemyMotion(enemy);
            else if (definition.MotionType == EnemyMotionType.Missile) enemy.MotionType = new MissileEnemyMotion(enemy);
            else if (definition.MotionType == EnemyMotionType.SeekerMissile) enemy.MotionType = new SeekerEnemyMotion(enemy);
            else if (definition.MotionType == EnemyMotionType.Hop) enemy.MotionType = new HopEnemyMotion(enemy);
            else if (definition.MotionType == EnemyMotionType.FastHop) enemy.MotionType = new FastHopEnemyMotion(enemy);
            else if (definition.MotionType == EnemyMotionType.FastFlying) enemy.MotionType = new FastFlyingEnemyMotion(enemy);
            else if (definition.MotionType == EnemyMotionType.SlowSeekerMissile) enemy.MotionType = new SlowSeekerEnemyMotion(enemy);
            else enemy.MotionType = new NoEnemyMotion(enemy);

            return enemy;
        }

    }
}
