﻿using System.IO;
using RawResources.Models;
using RawResources.Repository;


namespace RawResources.Manager
{
    public class DefaultRawContentManager : IRawContentManager
    {
        public IRawContentRepository<RawResource> FontRepository { get; private set; }
        public IRawContentRepository<RawResource> SongRepository { get; private set; }
        public IRawContentRepository<RawResource> TextureRepository { get; private set; }
        public IRawContentRepository<RawResource> SoundEffectRepository { get; private set; }
        public IRawContentRepository<TileSetDefinition> TileSetRepository { get; private set; }
        public IRawContentRepository<WorldMapDefinition> WorldMapRepository { get; private set; }
        public IRawContentRepository<PlayerDefinition> PlayerRepository { get; private set; }
        public IRawContentRepository<DestructableBlockDefinition> DestructableBlockRepository { get; private set; }
        public IRawContentRepository<EnemyDefinition> EnemyRepository { get; private set; } 


        public DefaultRawContentManager() : this("")
        {

        }


        public DefaultRawContentManager(string path)
        {
            if (path.Equals("") == false) path += Path.DirectorySeparatorChar;

            this.FontRepository = new FileRawContentRepository(path + "fonts.csv");
            this.SongRepository = new FileRawContentRepository(path + "songs.csv");
            this.TextureRepository = new FileRawContentRepository(path + "textures.csv");
            this.SoundEffectRepository = new FileRawContentRepository(path + "soundeffects.csv");
            this.TileSetRepository = new FileTileSetRepository(path + "tilesets.csv");
            this.WorldMapRepository = new FileWorldMapRepository(path + "worldmaps.csv");
            this.PlayerRepository = new FilePlayerRepository(path + "player.csv");
            this.DestructableBlockRepository = new FileDestructableBlockRepository(path + "destructableblocks.csv");
            this.EnemyRepository = new FileEnemyRepository(path + "enemies.csv");
        }

    }
}
