﻿using RawResources.Models;
using System;
using System.Collections.Generic;
using System.IO;


namespace RawResources.Repository
{
    public class FileRawContentRepository : IRawContentRepository<RawResource>
    {
        private IDictionary<int, RawResource> contentsByKey;
        private IList<int> keys;


        public FileRawContentRepository(string filename)
        {
            Load(filename);
        }


        public RawResource GetContent(int key)
        {
            RawResource content = null;

            if (this.contentsByKey.ContainsKey(key))
            {
                content = this.contentsByKey[key];
            }

            return content;
        }


        public void RemoveContent(int key)
        {
            if(this.contentsByKey.ContainsKey(key))
            {
                this.contentsByKey.Remove(key);
                this.keys.Remove(key);
            }
        }


        public void AddContent(RawResource content)
        {
            int key = GetMaxKey() + 1;

            content.Key = key;

            this.contentsByKey.Add(key, content);
            this.keys.Add(key);
        }


        private int GetMaxKey()
        {
            int maxKey = -1;

            foreach (int key in this.keys)
            {
                if (maxKey < key) maxKey = key;
            }

            return maxKey;
        }


        public IList<RawResource> GetListOfContent()
        {
            IList<RawResource> content = new List<RawResource>();
            IList<int> keys = GetKeys();

            foreach(int key in keys)
            {
                content.Add(contentsByKey[key]);
            }

            return content;
        }


        public IList<int> GetKeys()
        {
            return this.keys;
        }


        public void Load(string filename)
        {
            Stream stream = null;
            StreamReader reader = null;
            string line = null;
            string[] lineContents = null;
            

            this.contentsByKey = new Dictionary<int, RawResource>();
            this.keys = new List<int>();

            try
            {
                stream = File.OpenRead(filename);
                reader = new StreamReader(stream);
            }
            catch (Exception e)
            {
                Console.Error.WriteLine(e.Message);
                return;
            }

            //skip first line
            reader.ReadLine();

            while ((line = reader.ReadLine()) != null)
            {
                lineContents = line.Split(',');

                LoadContent(lineContents);
            }

            reader.Close();
        }


        private void LoadContent(string[] lineContents)
        {
            RawResource item = null;

            if (lineContents[0].Equals("") == false)
            {
                item = new RawResource()
                {
                    Key = Int32.Parse(lineContents[0]),
                    FilePath = lineContents[1]
                };


            }

            this.contentsByKey.Add(item.Key, item);
            this.keys.Add(item.Key);
        }


        public void Save(string filename)
        {
            StreamWriter writer = new StreamWriter(filename, false);

            writer.WriteLine(TileSetDefinition.GetCsvTitle());

            foreach (int key in this.keys)
            {
                RawResource rawResource = this.contentsByKey[key];

                writer.WriteLine(rawResource.ToCsvString());
            }

            writer.Close();
        }

    }
}
