﻿using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using System;
using System.Collections.Generic;
using UserInterface.Helper;


namespace UserInterface.Control
{
    public class Label : IControl
    {
        public IList<IControl> Controls { get; }

        public SpriteFont Font { get; set; }

        public bool IsSelected { get; set; }
        public bool CropTextToFitWidth { get; set; }
        public bool IsSelectable { get; }
        private Rectangle location;
        private Vector2 textLocation;
        private string textToDraw;
        private Vector2 textLocationVector;

        public Label()
        {
            this.Controls = new List<IControl>();
            this.IsSelectable = false;
            this.CropTextToFitWidth = false;
        }


        public string Text
        {
            get
            {
                return textToDraw;
            }
            set
            {
                if (CropTextToFitWidth == false) this.textToDraw = value;
                else this.textToDraw = TextHelper.GetCroppedText(value, this.Font, this.Location.Width);
            }
        }


        public Rectangle Location
        {
            get
            {
                return this.location;
            }
            set
            {
                this.location = value;

                this.textLocation = GetBestTextLocation();
                this.textLocationVector = new Vector2(textLocation.X, textLocation.Y);
            }
        }


        public void Draw(SpriteBatch spriteBatch)
        {
            spriteBatch.DrawString(this.Font, this.Text, textLocationVector, Color.White);
        }


        public void Update(long ticks)
        {

        }


        public void Press()
        {

        }


        private Vector2 GetBestTextLocation()
        {
            Vector2 vector = new Vector2(this.Location.X, this.Location.Y);

            if ((this.Text == null) || (this.Text.Equals(""))) return vector;
            if (this.Font == null) return vector;

            vector.Y += 16;
            vector.X += (this.Location.Width - this.Font.MeasureString(this.Text).X) / 2;

            return vector;
        }
    }
}