﻿using Microsoft.Xna.Framework.Graphics;


namespace UserInterface.Helper
{
    public class TextHelper
    {

        public static string GetCroppedText(string raw, SpriteFont font, int maxWidth)
        {
            if ((raw == null) || (raw.Equals(""))) return "";

            string result = raw;
            int rawWidth = (int)font.MeasureString(raw).X;

            if (rawWidth > maxWidth)
            {
                int avgCharacterWidth = rawWidth / raw.Length;
                int charactersPerLine = maxWidth / avgCharacterWidth;

                string[] words = raw.Split(' ');

                result = "";
                int lineLength = 0;
                for (int i = 0; i < words.Length; i++)
                {
                    if ((lineLength + words[i].Length) > charactersPerLine)
                    {
                        result += "\n";
                        lineLength = 0;
                    }

                    result += words[i] + " ";
                    lineLength += words[i].Length + 1;
                }
            }

            return result;
        }
    }
}