﻿using GameResources.Models.Game;
using Microsoft.Xna.Framework.Graphics;
using System;
using UserInterface.Control;


namespace UserInterface.Screen
{
    public class GameScreen : IScreen
    {
        public ControlCollection Controls { get; set; }
        private readonly IScreenController screenController;
        private GameViewer gameViewer;


        public GameScreen(IScreenController screenController)
        {
            this.Controls = new ControlCollection();
            this.screenController = screenController;

            Init();
        }


        private void Init()
        {
            this.gameViewer = new GameViewer(screenController.GameContentManager, screenController)
            {
                Location = new Microsoft.Xna.Framework.Rectangle(0, 0, screenController.Resolution.GameWidth, screenController.Resolution.GameHeight)
            };
            Controls.Add(gameViewer);
        }


        public void ActivateScreen()
        {
            gameViewer.GameState = screenController.GameState;
        }


        public void Draw(SpriteBatch spriteBatch)
        {
            for (int i = 0; i < this.Controls.Count; i++)
            {
                IControl control = this.Controls[i];
                control.Draw(spriteBatch);
            }
        }


        public void Update(long ticks)
        {
            if (screenController.GameState == null) return;

            //check for player death / gameover
            if (screenController.GameState.Player.CharacterStats.Health <= 0)
            {
                screenController.ChangeScreen(ScreenType.GameOver);
                return;
            }

            //check for victory
            if(screenController.GameState.IsVictory)
            {
                screenController.ChangeScreen(ScreenType.Victory);
                return;
            }

            InputMap inputMap = screenController.GetInputMap();

            if (screenController.LastKeyboardInputTicks >= (TimeSpan.TicksPerSecond * 0.3))
            {
                if (inputMap.Escape)
                {
                    screenController.LastKeyboardInputTicks = 0;

                    this.screenController.ChangeScreen(ScreenType.GameMenu);
                    return;
                }
            }

            //update player
            screenController.GameState.Player.InputMap = inputMap;

            //controls
            for (int i = 0; i < this.Controls.Count; i++)
            {
                IControl control = this.Controls[i];
                control.Update(ticks);
            }
        }

    }
}
