﻿using GameResources.Manager;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Media;
using System;
using UserInterface.Core;
using GameResources.Models.Game;


namespace UserInterface.Screen
{
    public interface IScreenController
    {
        SpriteBatch SpriteBatch { get; }
        IResolution Resolution { get; }
        Song BackgroundMusic { get; set; }
        long LastKeyboardInputTicks { get; set; }
        IGameContentManager GameContentManager { get; set; }
        GameState GameState { get; set; }
        void Exit();
        void ChangeScreen(ScreenType screenType);
        InputMap GetInputMap();
    }
}
