﻿using GameResources.Factories;
using GameResources.Logic.Game;
using GameResources.Manager;
using GameResources.Models.Game;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Media;
using System;
using UserInterface.Control;


namespace UserInterface.Screen
{
    public class MainMenuScreen : IScreen
    {
        public ControlCollection Controls { get; }
        private readonly IScreenController screenController;

        private long lastMovementInput;
        private long lastActionInput;


        public MainMenuScreen(IScreenController screenController)
        {
            this.Controls = new ControlCollection();
            this.screenController = screenController;

            Init();
        }


        public void Draw(SpriteBatch spriteBatch)
        {
            for(int i = 0; i < this.Controls.Count; i++)
            {
                IControl control = this.Controls[i];
                control.Draw(spriteBatch);
            }
        }


        public void Update(long ticks)
        {
            InputMap inputMap = screenController.GetInputMap();

            lastActionInput += ticks;
            lastMovementInput += ticks;

            //keyboard
            if (lastMovementInput >= (TimeSpan.TicksPerSecond * 0.12))
            {
                if (inputMap.Up)
                {
                    this.Controls.SelectPrev();
                    lastMovementInput = 0;
                }
                else if (inputMap.Down)
                {
                    this.Controls.SelectNext();
                    lastMovementInput = 0;
                }
            }

            if (lastActionInput >= (TimeSpan.TicksPerSecond * 0.12))
            {
                if (inputMap.Jump)
                {
                    if (this.Controls.IndexOfSelected() != -1)
                    {
                        lastActionInput = 0;
                        screenController.LastKeyboardInputTicks = 0;

                        this.Controls[this.Controls.IndexOfSelected()].Press();
                    }
                }
            }


            //controls
            for(int i = 0; i < this.Controls.Count; i++)
            {
                this.Controls[i].Update(ticks);
            }
        }


        public void ActivateScreen()
        {
            Song song = this.screenController.GameContentManager.SongRepository.GetContentByName(@"music\theme");

            if (MediaPlayer.State == MediaState.Playing)
            {
                MediaPlayer.Stop();
            }

            this.screenController.BackgroundMusic = song;
            MediaPlayer.IsRepeating = true;
            MediaPlayer.Play(song);

            lastMovementInput = screenController.LastKeyboardInputTicks;
            lastActionInput = screenController.LastKeyboardInputTicks;

            Init();
        }


        private void Init()
        {
            IGameContentManager gameContentManager = this.screenController.GameContentManager;

            int buttonWidth = 220;
            int buttonHeight = 32;
            int buttonStart = -32;
            int buttonSpace = 48;
            int screenWidth = screenController.Resolution.GameWidth;
            int screenHeight = screenController.Resolution.GameHeight;
            int screenHeightHalf = screenHeight / 2;

            this.Controls.Clear();

            this.Controls.Add(new Panel()
            {
                Location = new Rectangle(0, 0, screenWidth, screenHeight),
                Texture = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\bg-title")
            });

            this.Controls.Add(new Label()
            {
                Text = "Metroid",
                Font = gameContentManager.FontRepository.GetContentByName(@"fonts\Title"),
                Location = new Rectangle((screenWidth - 400) / 2, 40, 400, 100)
            });

            this.Controls.Add(new Label()
            {
                Text = "Crash Down",
                Font = gameContentManager.FontRepository.GetContentByName(@"fonts\Normal"),
                Location = new Rectangle((screenWidth - 400) / 2, 90, 400, 100)
            });

            GameLoader gameLoader = new GameLoader(gameContentManager);
            GameState slot1 = gameLoader.Preview(1);
            GameState slot2 = gameLoader.Preview(2);
            GameState slot3 = gameLoader.Preview(3);

            //slot1
            this.Controls.Add(new Button()
            {
                Text = (slot1 == null) ? "1 - New Game" : slot1.ToString(),
                Location = new Rectangle((screenWidth - buttonWidth) / 2, screenHeightHalf + buttonStart + (buttonSpace * 0), buttonWidth, buttonHeight),
                TextureNormal = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button"),
                TextureSelected = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button-select"),
                TexturePressed = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button-press"),
                Font = gameContentManager.FontRepository.GetContentByName(@"fonts\Normal"),
                PressSound = gameContentManager.SoundEffectRepository.GetContentByName(@"soundeffects\Samus Land"),
                IsSelected = true,
                CommandText = "1"
            });
            if(slot1 == null) ((Button)this.Controls[this.Controls.Count - 1]).OnClick += NewGame;
            else ((Button)this.Controls[this.Controls.Count - 1]).OnClick += LoadGame;

            if(slot1 != null)
            {
                this.Controls.Add(new Button()
                {
                    Text = "Clear",
                    Location = new Rectangle((screenWidth - buttonWidth) / 2 + buttonWidth + buttonSpace/2, screenHeightHalf + buttonStart + (buttonSpace * 0), buttonWidth / 2, buttonHeight),
                    TextureNormal = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button"),
                    TextureSelected = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button-select"),
                    TexturePressed = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button-press"),
                    Font = gameContentManager.FontRepository.GetContentByName(@"fonts\Normal"),
                    PressSound = gameContentManager.SoundEffectRepository.GetContentByName(@"soundeffects\Samus Land"),
                    IsSelected = false,
                    CommandText = "1"
                });
                ((Button)this.Controls[this.Controls.Count - 1]).OnClick += DeleteGame;
            }

            //slot 2
            this.Controls.Add(new Button()
            {
                Text = (slot2 == null) ? "2 - New Game" : slot2.ToString(),
                Location = new Rectangle((screenWidth - buttonWidth) / 2, screenHeightHalf + buttonStart + (buttonSpace * 1), buttonWidth, buttonHeight),
                TextureNormal = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button"),
                TextureSelected = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button-select"),
                TexturePressed = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button-press"),
                Font = gameContentManager.FontRepository.GetContentByName(@"fonts\Normal"),
                PressSound = gameContentManager.SoundEffectRepository.GetContentByName(@"soundeffects\Samus Land"),
                IsSelected = false,
                CommandText = "2"
            });
            if (slot2 == null) ((Button)this.Controls[this.Controls.Count - 1]).OnClick += NewGame;
            else ((Button)this.Controls[this.Controls.Count - 1]).OnClick += LoadGame;

            if (slot2 != null)
            {
                this.Controls.Add(new Button()
                {
                    Text = "Clear",
                    Location = new Rectangle((screenWidth - buttonWidth) / 2 + buttonWidth + buttonSpace / 2, screenHeightHalf + buttonStart + (buttonSpace * 1), buttonWidth / 2, buttonHeight),
                    TextureNormal = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button"),
                    TextureSelected = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button-select"),
                    TexturePressed = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button-press"),
                    Font = gameContentManager.FontRepository.GetContentByName(@"fonts\Normal"),
                    PressSound = gameContentManager.SoundEffectRepository.GetContentByName(@"soundeffects\Samus Land"),
                    IsSelected = false,
                    CommandText = "2"
                });
                ((Button)this.Controls[this.Controls.Count - 1]).OnClick += DeleteGame;
            }

            //slot 3
            this.Controls.Add(new Button()
            {
                Text = (slot3 == null) ? "3 - New Game" : slot3.ToString(),
                Location = new Rectangle((screenWidth - buttonWidth) / 2, screenHeightHalf + buttonStart + (buttonSpace * 2), buttonWidth, buttonHeight),
                TextureNormal = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button"),
                TextureSelected = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button-select"),
                TexturePressed = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button-press"),
                Font = gameContentManager.FontRepository.GetContentByName(@"fonts\Normal"),
                PressSound = gameContentManager.SoundEffectRepository.GetContentByName(@"soundeffects\Samus Land"),
                IsSelected = false,
                CommandText = "3"
            });
            if (slot3 == null) ((Button)this.Controls[this.Controls.Count - 1]).OnClick += NewGame;
            else ((Button)this.Controls[this.Controls.Count - 1]).OnClick += LoadGame;

            if (slot3 != null)
            {
                this.Controls.Add(new Button()
                {
                    Text = "Clear",
                    Location = new Rectangle((screenWidth - buttonWidth) / 2 + buttonWidth + buttonSpace / 2, screenHeightHalf + buttonStart + (buttonSpace * 2), buttonWidth / 2, buttonHeight),
                    TextureNormal = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button"),
                    TextureSelected = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button-select"),
                    TexturePressed = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button-press"),
                    Font = gameContentManager.FontRepository.GetContentByName(@"fonts\Normal"),
                    PressSound = gameContentManager.SoundEffectRepository.GetContentByName(@"soundeffects\Samus Land"),
                    IsSelected = false,
                    CommandText = "3"
                });
                ((Button)this.Controls[this.Controls.Count - 1]).OnClick += DeleteGame;
            }

            this.Controls.Add(new Button()
            {
                Text = "Exit",
                Location = new Rectangle((screenWidth - buttonWidth) / 2, screenHeightHalf + buttonStart + (buttonSpace * 3), buttonWidth, buttonHeight),
                TextureNormal = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button"),
                TextureSelected = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button-select"),
                TexturePressed = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button-press"),
                PressSound = gameContentManager.SoundEffectRepository.GetContentByName(@"soundeffects\Samus Land"),
                Font = gameContentManager.FontRepository.GetContentByName(@"fonts\Normal")
            });
            ((Button)this.Controls[this.Controls.Count - 1]).OnClick += CloseGame;

            this.Controls.Add(new Label()
            {
                Font = gameContentManager.FontRepository.GetContentByName(@"fonts\Normal"),
                Text = "Controls\n--------\n\nShoot = W\nJump = X\nMove = Arrows\nChange Weapon = A\nAim Up = Z\nAim Down = C\nMenu = Escape\nAccept = X\nToggle Fullscreen = ~",
                Location = new Rectangle(0, 350, 350, 200)
            }); ;
        }


        private void NewGame(object sender)
        {
            Button button = (Button)sender;
            int slot = Int32.Parse(button.CommandText);

            GameStateFactory gameStateFactory = new GameStateFactory(screenController.GameContentManager);
            this.screenController.GameState = gameStateFactory.CreateNew();
            this.screenController.GameState.GameSlot = slot;

            this.screenController.ChangeScreen(ScreenType.Story);
        }


        private void LoadGame(object sender)
        {
            Button button = (Button)sender;
            int slot = Int32.Parse(button.CommandText);

            GameLoader gameLoader = new GameLoader(screenController.GameContentManager);
            this.screenController.GameState = gameLoader.Load(slot);

            this.screenController.ChangeScreen(ScreenType.Game);
        }


        private void DeleteGame(object sender)
        {
            Button button = (Button)sender;
            int slot = Int32.Parse(button.CommandText);

            GameDeleter gameDeleter = new GameDeleter();
            gameDeleter.Delete(slot);

            Init();
        }


        private void CloseGame(object sender)
        {
            this.screenController.Exit();
        }


    }
}
