﻿using Avalonia.Controls;
using Avalonia.Interactivity;
using Avalonia.Markup.Xaml;
using MessageBox.Avalonia.Enums;
using RawResources.Models;
using System;


namespace GameMakerAvalonia.Dialogs
{
    public class DoorSelectDialog : Window
    {
        public ButtonResult DialogResult { get; set; }
        public DoorDirection SelectedDoorDirection { get; set; }
        public DamageType SelectedDamageType { get; set; }


        public DoorSelectDialog()
        {
            this.InitializeComponent();
        }


        private void InitializeComponent()
        {
            AvaloniaXamlLoader.Load(this);

            this.DialogResult = ButtonResult.Cancel;
            this.FindControl<Button>("AcceptButton").Click += AcceptButton_Click;
            this.FindControl<Button>("CancelButton").Click += CancelButton_Click;

            LoadComboBoxes();
        }


        private void LoadComboBoxes()
        {
            ComboBox damageComboBox = this.FindControl<ComboBox>("DamageComboBox");
            ComboBox directionComboBox = this.FindControl<ComboBox>("DirectionComboBox");

            damageComboBox.Items = Enum.GetValues(typeof(DamageType));
            directionComboBox.Items = Enum.GetValues(typeof(DoorDirection));

            damageComboBox.SelectedIndex = 0;
            directionComboBox.SelectedIndex = 0;
        }


        public void SetParameters(DamageType damageType, DoorDirection direction)
        {
            ComboBox damageComboBox = this.FindControl<ComboBox>("DamageComboBox");
            ComboBox directionComboBox = this.FindControl<ComboBox>("DirectionComboBox");

            damageComboBox.SelectedItem = damageType;
            directionComboBox.SelectedItem = direction;
        }


        private void CancelButton_Click(object sender, RoutedEventArgs e)
        {
            this.DialogResult = ButtonResult.Cancel;
            this.Hide();
        }


        private void AcceptButton_Click(object sender, RoutedEventArgs e)
        {
            ComboBox damageComboBox = this.FindControl<ComboBox>("DamageComboBox");
            ComboBox directionComboBox = this.FindControl<ComboBox>("DirectionComboBox");

            this.SelectedDamageType = (DamageType)damageComboBox.SelectedItem;
            this.SelectedDoorDirection = (DoorDirection)directionComboBox.SelectedItem;

            this.DialogResult = ButtonResult.Ok;
            this.Close();
        }


    }
}
