﻿using Avalonia.Controls;
using Avalonia.Interactivity;
using Avalonia.Markup.Xaml;
using MessageBox.Avalonia.Enums;
using RawResources.Models;
using System;


namespace GameMakerAvalonia.Dialogs
{
    public class ItemSelectDialog : Window
    {
        public ButtonResult DialogResult { get; set; }
        public ItemType SelectedItemType { get; set; }


        public ItemSelectDialog()
        {
            this.InitializeComponent();
        }


        private void InitializeComponent()
        {
            AvaloniaXamlLoader.Load(this);

            this.DialogResult = ButtonResult.Cancel;
            this.FindControl<Button>("AcceptButton").Click += AcceptButton_Click;
            this.FindControl<Button>("CancelButton").Click += CancelButton_Click;

            LoadComboBoxes();
        }

        private void LoadComboBoxes()
        {
            ComboBox itemTypeComboBox = this.FindControl<ComboBox>("ItemTypeComboBox");

            itemTypeComboBox.Items = Enum.GetValues(typeof(ItemType));

            itemTypeComboBox.SelectedIndex = 0;
        }

        public void SetParameters(ItemType itemType)
        {
            ComboBox itemTypeComboBox = this.FindControl<ComboBox>("ItemTypeComboBox");

            itemTypeComboBox.SelectedItem = itemType;
        }


        private void CancelButton_Click(object sender, RoutedEventArgs e)
        {
            this.DialogResult = ButtonResult.Cancel;
            this.Hide();
        }


        private void AcceptButton_Click(object sender, RoutedEventArgs e)
        {
            ComboBox itemTypeComboBox = this.FindControl<ComboBox>("ItemTypeComboBox");

            this.SelectedItemType = (ItemType)itemTypeComboBox.SelectedItem;

            this.DialogResult = ButtonResult.Ok;
            this.Close();
        }


    }
}
