﻿using SixLabors.ImageSharp;
using SixLabors.ImageSharp.Processing;
using System.IO;
using IBitmap = Avalonia.Media.Imaging.IBitmap;
using Bitmap = Avalonia.Media.Imaging.Bitmap;


namespace GameMakerAvalonia.Logic
{
    public class ImageManip
    {

        public static IBitmap GetImageSubset(string filename, int x, int y, int w, int h)
        {
            Image source = Image.Load(filename);
            Rectangle sourceAreaRect = new Rectangle(x, y, w, h);

            source.Mutate(a => a.Crop(sourceAreaRect));

            Stream destStream = new MemoryStream();
            source.SaveAsPng(destStream);
            destStream.Position = 0;

            IBitmap destination = new Bitmap(destStream);

            return destination;
        }

    }
}
