﻿using Avalonia.Controls;
using Avalonia.Interactivity;
using Avalonia.Markup.Xaml;
using GameMakerAvalonia.Models;
using LibVLCSharp.Shared;
using RawResources.Models;
using System;
using System.Collections.Generic;
using System.IO;

namespace GameMakerAvalonia.Panels
{
    public class SoundEffectsPanel : UserControl
    {
        private Session session;
        private IList<RawResource> resources;
        private LibVLC vlc;
        private MediaPlayer mediaPlayer;


        public SoundEffectsPanel()
        {
            this.InitializeComponent();
        }


        private void InitializeComponent()
        {
            AvaloniaXamlLoader.Load(this);

            this.FindControl<Button>("PlayButton").Click += PlayButton_Click;
            this.FindControl<DataGrid>("ListGridView").CurrentCellChanged += ListGridView_CurrentCellChanged;
        }


        public void SetSession(Session session)
        {
            this.session = session;

            LoadSession();
        }


        private void LoadSession()
        {
            this.resources = session.RawContentManager.SoundEffectRepository.GetListOfContent();

            var grid = this.FindControl<DataGrid>("ListGridView");
            grid.Items = resources;
        }


        private void ListGridView_CurrentCellChanged(object sender, EventArgs e)
        {

        }


        private void PlayButton_Click(object sender, RoutedEventArgs e)
        {
            var grid = this.FindControl<DataGrid>("ListGridView");

            if (grid.SelectedItem == null) return;

            if (vlc == null || mediaPlayer == null)
            {
                this.vlc = new LibVLC();
                this.mediaPlayer = new MediaPlayer(this.vlc);
            }

            if (this.mediaPlayer.IsPlaying)
            {
                this.mediaPlayer.Stop();
            }
            else
            {
                RawResource item = (RawResource)grid.SelectedItem;
                string filename = this.session?.WorkingDirectory + Path.DirectorySeparatorChar + "Content" + Path.DirectorySeparatorChar + item.SystemFilePath + ".wav";

                Media media = new Media(this.vlc, filename);
                this.mediaPlayer.Play(media);
            }
        }


    }
}
