﻿using GameResources.Logic.Physics;
using GameResources.Models.Game;
using GameResources.Models.World;


namespace GameResources.Logic.EnemyMotion
{
    public class BounceEnemyMotion : IEnemyMotion
    {
        private Enemy enemy;
        private float xDirection;
        private float yDirection;


        public BounceEnemyMotion(Enemy enemy)
        {
            this.enemy = enemy;
            this.xDirection = 1;
            this.yDirection = 1;
        }


        public void Do(long ticks, GameState gameState)
        {
            enemy.Motion.VelocityX = 4 * xDirection;
            enemy.Motion.VelocityY = 4 * yDirection;

            PhysicsEngine physics = new PhysicsEngine(enemy, gameState.GetActiveWorldMapCell(), gameState, false);
            physics.IgnoreObjects.Add(gameState.Player);
            physics.Update();

            if (enemy.Motion.VelocityX == 0) xDirection = xDirection * -1;
            if (enemy.Motion.VelocityY == 0) yDirection = yDirection * -1;
        }

    }
}
