﻿using GameResources.Logic.Physics;
using GameResources.Models.Game;
using GameResources.Models.Physics;
using GameResources.Models.World;
using Microsoft.Xna.Framework;
using RawResources.Models;


namespace GameResources.Logic.EnemyMotion
{
    public class SeekerEnemyMotion : IEnemyMotion
    {
        private Enemy enemy;
        private float xDirection;
        private float yDirection;


        public SeekerEnemyMotion(Enemy enemy)
        {
            this.enemy = enemy;
            this.xDirection = 0;
            this.yDirection = 0;
        }


        public void Do(long ticks, GameState gameState)
        {
            //find player
            WorldPosition pPos = gameState.Player.Position;
            WorldPosition ePos = this.enemy.Position;

            Motion motion = new Motion()
            {
                VelocityX = pPos.PositionX - ePos.PositionX,
                VelocityY = pPos.PositionY - ePos.PositionY
            };

            Vector2 vector = motion.UnitVector;

            xDirection = vector.X;
            yDirection = vector.Y;

            //set speed
            enemy.Motion.VelocityX = 4 * xDirection;
            enemy.Motion.VelocityY = 4 * yDirection;

            PhysicsEngine physics = new PhysicsEngine(enemy, gameState.GetActiveWorldMapCell(), gameState, false);
            physics.IgnoreObjects.Add(gameState.Player);
            physics.Update();

            //set speed again for explosive testing
            enemy.Motion.VelocityX = 4 * xDirection;
            enemy.Motion.VelocityY = 4 * yDirection;
        }

    }
}
