﻿using GameResources.Models.Game;
using GameResources.Models.World;


namespace GameResources.Logic.Physics
{
    public class EnemyPositionAdjuster
    {
        private readonly WorldMapCell worldMapCell;
        private readonly GameState gameState;
        private readonly Enemy enemy;


        public EnemyPositionAdjuster(Enemy enemy, GameState gameState)
        {
            this.enemy = enemy;
            this.gameState = gameState;
            this.worldMapCell = gameState.GetActiveWorldMapCell();
        }


        public void AdjustIfNeeded()
        {
            CollisionDetection collisionDetection = new CollisionDetection(this.enemy, this.worldMapCell, this.gameState);
            if (collisionDetection.HasCollidedInWorld() == false) return;

            if (enemy.Textures.Count == 0) return;
            if (enemy.Textures[0].Name.Contains("blank")) return;

            for (int dx = 1; dx <= 48; dx++)
            {
                if (collisionDetection.HasCollidedInWorldAtPosition(this.enemy.Position.PositionX - dx, this.enemy.Position.PositionY) == false)
                {
                    this.enemy.Position.PositionX -= dx;
                    break;
                }
                else if (collisionDetection.HasCollidedInWorldAtPosition(this.enemy.Position.PositionX + dx, this.enemy.Position.PositionY) == false)
                {
                    this.enemy.Position.PositionX += dx;
                    break;
                }
            }

            for (int dy = 1; dy <= 48; dy++)
            {
                if (collisionDetection.HasCollidedInWorldAtPosition(this.enemy.Position.PositionX, this.enemy.Position.PositionY - dy) == false)
                {
                    this.enemy.Position.PositionY -= dy;
                    break;
                }
                else if (collisionDetection.HasCollidedInWorldAtPosition(this.enemy.Position.PositionX, this.enemy.Position.PositionY + dy) == false)
                {
                    this.enemy.Position.PositionY += dy;
                    break;
                }
            }
        }

    }
}
