﻿using GameResources.Manager;
using GameResources.Models.Characters;
using GameResources.Models.Game;
using GameResources.Models.Weapons;
using RawResources.Models;


namespace GameResources.Logic.Weapons
{
    public class SuperBombPlacer
    {
        private readonly GameState gameState;
        private readonly IGameContentManager gameContentManager;


        public SuperBombPlacer(GameState gameState, IGameContentManager gameContentManager)
        {
            this.gameState = gameState;
            this.gameContentManager = gameContentManager;
        }


        public void Do(IBattleObject caster, WorldPosition launchPosition)
        {
            SuperBomb bomb = new SuperBomb(gameContentManager.TextureRepository, caster);

            bomb.Position = launchPosition.Copy();

            gameState.ActiveWeaponSprites.Add(bomb);

            gameContentManager.SoundEffectRepository.GetContentByName(@"soundeffects\Bomb Place").Play();
        }

    }
}
