﻿using GameResources.Models.Samus;
using GameResources.Models.World;
using GameResources.Repository;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Media;
using RawResources.Manager;


namespace GameResources.Manager
{
    public class DefaultGameContentManager : IGameContentManager
    {
        public IGameNamedContentRepository<SpriteFont> FontRepository { get; private set; }
        public IGameNamedContentRepository<Song> SongRepository { get; private set; }
        public IGameNamedContentRepository<Texture2D> TextureRepository { get; private set; }
        public IGameNamedContentRepository<SoundEffect> SoundEffectRepository { get; private set; }
        public IGameContentRepository<TileSet> TileSetRepository { get; private set; }
        public IGameContentRepository<Player> PlayerRepository { get; private set; }
        public IGameContentRepository<WorldMap> WorldMapRepository { get; private set; }
        public IGameContentRepository<DestructableBlock> DestructableBlockRepository { get; private set; }
        public IGameContentRepository<Enemy> EnemyRepository { get; private set; }


        public DefaultGameContentManager(ContentManager contentManager, IRawContentManager rawContentManager)
        {
            this.FontRepository = new CachedRawResourceRepository<SpriteFont>(contentManager, rawContentManager.FontRepository);
            this.SongRepository = new CachedRawResourceRepository<Song>(contentManager, rawContentManager.SongRepository);
            this.TextureRepository = new CachedRawResourceRepository<Texture2D>(contentManager, rawContentManager.TextureRepository);
            this.SoundEffectRepository = new CachedRawResourceRepository<SoundEffect>(contentManager, rawContentManager.SoundEffectRepository);
            
            this.TileSetRepository = new CachedTileSetRepository(rawContentManager.TileSetRepository, this.TextureRepository);
            this.DestructableBlockRepository = new DirectDestructableBlockRepository(rawContentManager.DestructableBlockRepository, this.TileSetRepository);
            this.PlayerRepository = new DirectPlayerRepository(rawContentManager.PlayerRepository, this.TextureRepository);
            this.EnemyRepository = new DirectEnemyRepository(rawContentManager.EnemyRepository, this.TextureRepository);
            this.WorldMapRepository = new CachedWorldMapRepository(rawContentManager.WorldMapRepository, this.TileSetRepository, this.SongRepository, this.TextureRepository);
        }


    }
}
