﻿using GameResources.Models.Samus;
using GameResources.Models.World;
using GameResources.Repository;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Media;


namespace GameResources.Manager
{
    public interface IGameContentManager
    {
        IGameNamedContentRepository<SpriteFont> FontRepository { get; }
        IGameNamedContentRepository<Song> SongRepository { get; }
        IGameNamedContentRepository<Texture2D> TextureRepository { get; }
        IGameNamedContentRepository<SoundEffect> SoundEffectRepository { get; }
        IGameContentRepository<TileSet> TileSetRepository { get; }
        IGameContentRepository<Player> PlayerRepository { get; }
        IGameContentRepository<WorldMap> WorldMapRepository { get; }
        IGameContentRepository<DestructableBlock> DestructableBlockRepository { get; }
        IGameContentRepository<Enemy> EnemyRepository { get; }
    }
}
