﻿using GameResources.Manager;
using GameResources.Models.Game;
using GameResources.Models.Physics;
using GameResources.Models.World;
using GameResources.Repository;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using RawResources.Models;


namespace GameResources.Models.Effects
{
    public class WaterEffect : IEffect, IMoveableObject
    {
        public bool IsExpired { get; set; }
        public WorldPosition Position { get; set; }
        public Motion Motion { get; set; }

        private readonly Texture2D bodyTexture;
        private readonly Texture2D topTexture;
        private readonly WorldMapCell worldMapCell;
        private readonly int height;
        private readonly int width;
        private readonly int textureSize;

        public WaterEffect(IGameNamedContentRepository<Texture2D> textureRepository, WorldMapCell worldMapCell, int height)
        {
            this.worldMapCell = worldMapCell;
            this.bodyTexture = textureRepository.GetContentByName(@"textures\effects\water");
            this.topTexture = textureRepository.GetContentByName(@"textures\effects\water-top");
            
            this.Motion = new Motion();

            this.height = height;
            this.width = worldMapCell.GetMaxTileX() * TileSet.DRAW_SIZE;
            this.Position = new WorldPosition()
            {
                PositionX = 0,
                PositionY = (worldMapCell.GetMaxTileY() * TileSet.DRAW_SIZE) - height,
                WorldCellX = worldMapCell.WorldMapX,
                WorldCellY = worldMapCell.WorldMapY,
                WorldMapKey = worldMapCell.WorldKey
            };

            this.textureSize = this.bodyTexture.Height;
        }


        public void Draw(SpriteBatch spriteBatch, long dx, long dy)
        {
            //top
            if(this.Position.PositionY != 0)
            {
                for(int x = 0; x < width; x += textureSize)
                {
                    spriteBatch.Draw(topTexture, new Rectangle((int)(x - dx), (int)(this.Position.PositionY - dy), textureSize, textureSize), Color.White);
                }
            }

            //body
            for(int y = ((int)this.Position.PositionY != 0) ? (int)this.Position.PositionY + textureSize : (int)this.Position.PositionY; (y - this.Position.PositionY) < height; y += textureSize)
            {
                for(int x = 0; x < width; x += textureSize) 
                {
                    spriteBatch.Draw(bodyTexture, new Rectangle((int)(x - dx), (int)(y - dy), textureSize, textureSize), Color.White);
                }
            }

        }


        public void Update(long ticks)
        {
            //nothing
        }


        public void Update(GameState gameState, IGameContentManager gameContentManager, long ticks)
        {
            //nothing
        }


        public Rectangle GetCollisionAreaAtPosition(long x, long y)
        {
            return new Rectangle((int)x, (int)y, this.width, this.height);
        }


        public Rectangle GetCurrentCollisionArea()
        {
            return GetCollisionAreaAtPosition(this.Position.PositionX, this.Position.PositionY);
        }
        
    }
}
